/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.supplement;

import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.XLog;
import org.seasar.dbflute.bhv.core.supplement.SequenceCache;
import org.seasar.dbflute.bhv.core.supplement.SequenceCacheKeyGenerator;
import org.seasar.dbflute.exception.SequenceCacheIllegalStateException;
import org.seasar.dbflute.exception.SequenceCacheSizeNotDividedIncrementSizeException;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceCacheHandler {
    protected final Map<String, SequenceCache> _sequenceCacheMap = new ConcurrentHashMap<String, SequenceCache>();
    protected SequenceCacheKeyGenerator _sequenceCacheKeyGenerator;
    protected boolean _internalDebug;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceCache findSequenceCache(String tableName, String sequenceName, DataSource dataSource, Class<?> resultType, Integer cacheSize, Integer incrementSize) {
        if (cacheSize == null || cacheSize <= 1) {
            return null;
        }
        String key = this.generateKey(tableName, sequenceName, dataSource);
        SequenceCache sequenceCache = this.getSequenceCache(key);
        if (sequenceCache != null) {
            return sequenceCache;
        }
        Map<String, SequenceCache> map = this._sequenceCacheMap;
        synchronized (map) {
            sequenceCache = this.getSequenceCache(key);
            if (sequenceCache != null) {
                return sequenceCache;
            }
            if (this.isLogEnabled()) {
                this.log("...Initializing sequence cache: " + sequenceName + ":cache(" + cacheSize + ")");
            }
            sequenceCache = this.createSequenceCache(sequenceName, dataSource, resultType, cacheSize, incrementSize);
            this._sequenceCacheMap.put(key, sequenceCache);
        }
        if (sequenceCache == null) {
            String msg = "createSequenceCache() should not return null:";
            msg = msg + " sequenceName=" + sequenceName + " dataSource=" + dataSource;
            throw new SequenceCacheIllegalStateException(msg);
        }
        return sequenceCache;
    }

    protected SequenceCache getSequenceCache(String key) {
        return this._sequenceCacheMap.get(key);
    }

    protected SequenceCache createSequenceCache(String sequenceName, DataSource dataSource, Class<?> resultType, Integer cacheSize, Integer incrementSize) {
        SequenceCache cache = new SequenceCache(resultType, new BigDecimal(cacheSize), incrementSize);
        cache.setInternalDebug(this._internalDebug);
        return cache;
    }

    protected String generateKey(String tableName, String sequenceName, DataSource dataSource) {
        if (this._sequenceCacheKeyGenerator != null) {
            return this._sequenceCacheKeyGenerator.generateKey(tableName, sequenceName, dataSource);
        }
        return tableName + "." + sequenceName;
    }

    public String filterNextValSql(Integer cacheSize, Integer incrementSize, String nextValSql) {
        this.assertFilterArgumentValid(cacheSize, incrementSize, nextValSql);
        this.assertCacheSizeCanBeDividedByIncrementSize(cacheSize, incrementSize, nextValSql);
        Integer divided = cacheSize / incrementSize;
        Integer unionCount = divided - 1;
        StringBuilder sb = new StringBuilder();
        if (unionCount > 0) {
            if (ResourceContext.isCurrentDBDef(DBDef.Oracle)) {
                sb.append(this.buildNextValSqlOnOracle(nextValSql, divided, unionCount));
            } else if (ResourceContext.isCurrentDBDef(DBDef.DB2)) {
                sb.append(this.buildNextValSqlOnDB2(nextValSql, divided, unionCount));
            } else {
                sb.append(this.buildNextValSqlUsingUnionAll(nextValSql, divided, unionCount));
            }
        } else {
            sb.append(nextValSql);
        }
        return sb.toString();
    }

    protected String buildNextValSqlOnOracle(String nextValSql, Integer divided, Integer unionCount) {
        StringBuilder sb = new StringBuilder();
        sb.append(Srl.replace(nextValSql, "from dual", this.ln() + "  from ("));
        Integer maxDualCountInOneJoin = 10;
        int allRecordCount = 0;
        boolean reached = false;
        int i = 0;
        while (!reached) {
            if (i >= 1) {
                sb.append(this.ln()).append("    cross join (");
            }
            int dualCountInOneJoin = 0;
            sb.append("select * from dual");
            ++dualCountInOneJoin;
            String indent = i >= 1 ? "                " : "        ";
            int calculatedRecordCount = 0;
            for (int j = 0; j < maxDualCountInOneJoin - 1; ++j) {
                sb.append(this.ln()).append(indent).append(" union all");
                sb.append(this.ln()).append(indent).append("select * from dual");
                calculatedRecordCount = allRecordCount == 0 ? dualCountInOneJoin : allRecordCount * ++dualCountInOneJoin;
                if (calculatedRecordCount < divided) continue;
                reached = true;
                break;
            }
            allRecordCount = calculatedRecordCount;
            sb.append(") join_" + (i + 1));
            ++i;
        }
        sb.append(this.ln()).append(" where rownum <= " + divided);
        return sb.toString();
    }

    protected final String buildNextValSqlOnOracleUsingConnectBy(String nextValSql, Integer divided, Integer unionCount) {
        StringBuilder sb = new StringBuilder();
        String viewSql = "select level from dual connect by level <= " + unionCount;
        sb.append(Srl.replace(nextValSql, "from dual", "from (" + viewSql + ")"));
        return sb.toString();
    }

    protected String buildNextValSqlOnDB2(String nextValSql, Integer divided, Integer unionCount) {
        StringBuilder sb = new StringBuilder();
        String viewSql = "values (1) union all select N + 1 from NUM where n <= " + unionCount;
        sb.append("with NUM (N) as (").append(viewSql).append(")");
        sb.append(this.ln()).append(Srl.replace(nextValSql, "values", "select")).append(" from NUM");
        return sb.toString();
    }

    protected String buildNextValSqlUsingUnionAll(String nextValSql, Integer divided, Integer unionCount) {
        StringBuilder sb = new StringBuilder();
        sb.append(nextValSql);
        for (int i = 0; i < unionCount; ++i) {
            sb.append(this.ln()).append(" union all ");
            sb.append(this.ln()).append(nextValSql);
        }
        sb.append(this.ln()).append(" order by 1 asc");
        return sb.toString();
    }

    protected void assertFilterArgumentValid(Integer cacheSize, Integer incrementSize, String nextValSql) {
        if (cacheSize == null || cacheSize <= 1) {
            String msg = "The argument 'cacheSize' should be cache valid size: " + cacheSize;
            throw new SequenceCacheIllegalStateException(msg);
        }
        if (incrementSize == null || incrementSize <= 0) {
            String msg = "The argument 'incrementSize' should be plus size: " + incrementSize;
            throw new SequenceCacheIllegalStateException(msg);
        }
        if (nextValSql == null || nextValSql.trim().length() == 0) {
            String msg = "The argument 'nextValSql' should be valid: " + nextValSql;
            throw new SequenceCacheIllegalStateException(msg);
        }
    }

    protected void assertCacheSizeCanBeDividedByIncrementSize(Integer cacheSize, Integer incrementSize, String nextValSql) {
        Integer extraValue = cacheSize % incrementSize;
        if (extraValue != 0) {
            this.throwSequenceCacheSizeNotDividedIncrementSizeException(cacheSize, incrementSize, nextValSql);
        }
    }

    protected void throwSequenceCacheSizeNotDividedIncrementSizeException(Integer cacheSize, Integer incrementSize, String nextValSql) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The cache size cannot be divided by increment size!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm sequence increment size and dfcache size setting." + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    (x) - cacheSize = 50, incrementSize = 3" + this.ln();
        msg = msg + "    (x) - cacheSize = 50, incrementSize = 27" + this.ln();
        msg = msg + "    (o) - cacheSize = 50, incrementSize = 1" + this.ln();
        msg = msg + "    (o) - cacheSize = 50, incrementSize = 50" + this.ln();
        msg = msg + "    (o) - cacheSize = 50, incrementSize = 2" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Cache Size]" + this.ln() + cacheSize + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Increment Size]" + this.ln() + incrementSize + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL for Next Value]" + this.ln() + nextValSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new SequenceCacheSizeNotDividedIncrementSizeException(msg);
    }

    protected void log(String msg) {
        XLog.log(msg);
    }

    protected boolean isLogEnabled() {
        return XLog.isLogEnabled();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public void setSequenceCacheKeyGenerator(SequenceCacheKeyGenerator sequenceCacheKeyGenerator) {
        this._sequenceCacheKeyGenerator = sequenceCacheKeyGenerator;
    }

    public void setInternalDebug(boolean internalDebug) {
        this._internalDebug = internalDebug;
    }
}

