/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.command;

import java.util.List;
import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.dbflute.bhv.core.command.AbstractEntityCommand;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.sqlcommand.TnInsertAutoDynamicCommand;

public class InsertEntityCommand
extends AbstractEntityCommand {
    public String getCommandName() {
        return "insert";
    }

    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            public SqlExecution createSqlExecution() {
                TnBeanMetaData bmd = InsertEntityCommand.this.createBeanMetaData();
                return InsertEntityCommand.this.createInsertEntitySqlExecution(bmd);
            }
        };
    }

    protected SqlExecution createInsertEntitySqlExecution(TnBeanMetaData bmd) {
        SqlExecution nonPrimaryKeySqlExecution = this.createNonPrimaryInsertSqlExecution(bmd);
        if (nonPrimaryKeySqlExecution != null) {
            return nonPrimaryKeySqlExecution;
        }
        String[] propertyNames = this.getPersistentPropertyNames(bmd);
        return this.createInsertAutoDynamicCommand(bmd, propertyNames);
    }

    protected TnInsertAutoDynamicCommand createInsertAutoDynamicCommand(TnBeanMetaData bmd, String[] propertyNames) {
        TnInsertAutoDynamicCommand cmd = new TnInsertAutoDynamicCommand();
        cmd.setDataSource(this._dataSource);
        cmd.setStatementFactory(this._statementFactory);
        cmd.setBeanMetaData(bmd);
        cmd.setTargetDBMeta(this.findDBMeta());
        cmd.setPropertyNames(propertyNames);
        return cmd;
    }

    protected SqlExecution createNonPrimaryInsertSqlExecution(TnBeanMetaData bmd) {
        DBMeta dbmeta = this.findDBMeta();
        if (dbmeta.hasPrimaryKey()) {
            return null;
        }
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        StringBuilder columnDefSb = new StringBuilder();
        for (ColumnInfo columnInfo : columnInfoList) {
            columnDefSb.append(", ").append(columnInfo.getColumnSqlName());
        }
        columnDefSb.delete(0, ", ".length()).insert(0, "(").append(")");
        StringBuilder columnValuesSb = new StringBuilder();
        for (ColumnInfo columnInfo : columnInfoList) {
            columnValuesSb.append(", /*pmb.").append(columnInfo.getPropertyName()).append("*/null");
        }
        columnValuesSb.delete(0, ", ".length()).insert(0, "(").append(")");
        String sql = "insert into " + dbmeta.getTableSqlName() + columnDefSb + " values" + columnValuesSb;
        return this.createOutsideSqlExecuteExecution(new String[]{"pmb"}, new Class[]{this._entityType}, sql);
    }
}

