/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scaffold.util;

import java.util.Iterator;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.message.Note;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.redirection.impl.RedirectionScope;
import org.seasar.ymir.response.PassthroughResponse;
import org.seasar.ymir.scope.annotation.In;
import org.seasar.ymir.scope.annotation.Out;

public abstract class PageBase {
    public static final String SCHEME_FORWARD = "forward:";
    public static final String SCHEME_REDIRECT = "redirect:";
    public static final String SCHEME_PROCEED = "proceed:";
    public static final String PASSTHROUGH = "passthrough:";
    private Request ymirRequest;
    private Notes temporaryNotes;

    @Binding(bindingType=BindingType.MUST)
    public final void setYmirRequest(Request ymirRequest) {
        this.ymirRequest = ymirRequest;
    }

    public final Request getYmirRequest() {
        return this.ymirRequest;
    }

    protected final void addNote(String key) {
        this.addNote(false, key);
    }

    protected final void addNote(boolean temporary, String key) {
        this.addNote(temporary, new Note(key, new Object[0]));
    }

    protected final void addNote(String category, String key) {
        this.addNote(false, category, key);
    }

    protected final void addNote(boolean temporary, String category, String key) {
        this.addNote(temporary, category, new Note(key, new Object[0]));
    }

    protected final void addNote(Note note) {
        this.addNote(false, note);
    }

    protected final void addNote(boolean temporary, Note note) {
        if (note != null) {
            this.getNotes(temporary).add(note);
        }
    }

    protected final void addNote(String category, Note note) {
        this.addNote(false, category, note);
    }

    protected final void addNote(boolean temporary, String category, Note note) {
        if (note != null) {
            this.getNotes(temporary).add(category, note);
        }
    }

    protected final Notes getNotes() {
        return this.getNotes(false);
    }

    protected final Notes getNotes(boolean temporary) {
        Notes notes;
        if (temporary) {
            if (this.temporaryNotes == null) {
                this.temporaryNotes = new Notes();
            }
            notes = this.temporaryNotes;
        } else {
            notes = (Notes)this.ymirRequest.getAttribute("notes");
            if (notes == null) {
                notes = new Notes();
                this.ymirRequest.setAttribute("notes", (Object)notes);
            }
        }
        return notes;
    }

    @Out(value=RedirectionScope.class)
    public final Notes getTemporaryNotes() {
        return this.temporaryNotes;
    }

    @In(value=RedirectionScope.class)
    public final void setTemporaryNotes(Notes temporaryNotes) {
        Notes notes = this.getNotes();
        Iterator itr = temporaryNotes.categories();
        while (itr.hasNext()) {
            String category = (String)itr.next();
            for (Note note : temporaryNotes.getNotes(category)) {
                notes.add(category, note);
            }
        }
    }

    protected final Response passthrough() {
        return new PassthroughResponse();
    }
}

