/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scaffold.maintenance.web;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Map;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Phase;
import org.seasar.ymir.Response;
import org.seasar.ymir.annotation.Invoke;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.cache.CacheManager;
import org.seasar.ymir.constraint.ConstraintManager;
import org.seasar.ymir.constraint.ConstraintViolatedException;
import org.seasar.ymir.constraint.annotation.Validator;
import org.seasar.ymir.converter.TypeConversionManager;
import org.seasar.ymir.dbflute.EntityManager;
import org.seasar.ymir.dbflute.constraint.annotation.FittedOnDBType;
import org.seasar.ymir.scaffold.maintenance.dto.ViewDto;
import org.seasar.ymir.scaffold.maintenance.enm.Action;
import org.seasar.ymir.scaffold.maintenance.web.EntityBean;
import org.seasar.ymir.scaffold.util.MaskingMap;
import org.seasar.ymir.scaffold.util.PageBase;
import org.seasar.ymir.scaffold.util.Redirect;
import org.seasar.ymir.scope.ScopeManager;
import org.seasar.ymir.scope.annotation.RequestParameter;
import org.seasar.ymir.scope.annotation.URIParameter;
import org.seasar.ymir.session.SessionManager;
import org.seasar.ymir.zpt.annotation.ParameterHolder;

@ParameterHolder(value="entity")
public class MaintenancePage
extends PageBase {
    private static final FittedOnDBType FITTED_ON_DB_TYPE = new FittedOnDBType(){

        public String messageKey() {
            return "";
        }

        public Class<? extends Annotation> annotationType() {
            return FittedOnDBType.class;
        }
    };
    @Binding(bindingType=BindingType.MUST)
    protected AnnotationHandler annotationHandler;
    @Binding(bindingType=BindingType.MUST)
    protected ConstraintManager constraintManager;
    @Binding(bindingType=BindingType.MUST)
    protected EntityManager entityManager;
    @Binding(bindingType=BindingType.MUST)
    protected SessionManager sessionManager;
    @Binding(bindingType=BindingType.MUST)
    protected TypeConversionManager typeConversionManager;
    @Binding(bindingType=BindingType.MUST)
    protected ScopeManager scopeManager;
    private Map<Class<?>, EntityBean> entityBeanCacheMap;
    private EntityBean entityBean;
    private Action action;
    private ViewDto view;
    private Entity entity;

    @Binding(bindingType=BindingType.MUST)
    public void setCacheManager(CacheManager cacheManager) {
        this.entityBeanCacheMap = cacheManager.newMap();
    }

    @Invoke(value=Phase.PAGECOMPONENT_CREATED)
    public void initialize() {
        this.entityBean = this.getEntityBean();
    }

    protected EntityBean getEntityBean() {
        Class<?> key = this.getClass();
        EntityBean bean = this.entityBeanCacheMap.get(key);
        if (bean == null) {
            String path = this.getYmirRequest().getPath();
            String entityName = path.substring(1, path.indexOf("/", 1));
            bean = new EntityBean(this.annotationHandler, this.entityManager, this.typeConversionManager, entityName, this.getClass());
            this.entityBeanCacheMap.put(key, bean);
        }
        return bean;
    }

    protected String getSessionKey(String key) {
        if (key == null) {
            return null;
        }
        return this.entityBean.getEntityName() + "." + key;
    }

    @URIParameter
    public void setAction(String action) {
        this.action = Action.enumOf(action);
    }

    @Invoke(value=Phase.OBJECT_INJECTED)
    public void initializeView() {
        this.view = new ViewDto(this.entityBean, this.action);
    }

    @Invoke(value=Phase.OBJECT_POPULATED, actionName={".*_add"})
    public void prepareEntityForAdd() {
        if (this.getYmirRequest().getMethod() == HttpMethod.POST) {
            this.entity = this.populateParameters(this.entityBean.newEntity());
        }
    }

    @Invoke(value=Phase.OBJECT_POPULATED, actionName={".*_edit"})
    public void prepareEntityForEdit() {
        this.entity = this.entityBean.loadEntity(this.getYmirRequest());
        if (this.getYmirRequest().getMethod() == HttpMethod.POST) {
            this.entity = this.populateParameters(this.entity);
        }
    }

    @Invoke(value=Phase.OBJECT_POPULATED, actionName={".*_delete"})
    public void prepareEntityForDelete() {
        this.entity = this.entityBean.loadEntity(this.getYmirRequest());
    }

    private Entity populateParameters(Entity entity) {
        this.scopeManager.populateQuietly((Object)entity, new MaskingMap(this.getYmirRequest().getParameterMap(), this.entityBean.getUpdatableColumnNames(this.action)));
        return entity;
    }

    @Validator(value={"_post_do_.*"})
    public void validate() throws ConstraintViolatedException {
        this.constraintManager.confirmConstraint((Object)this, this.getYmirRequest(), (Annotation)FITTED_ON_DB_TYPE, this.entityBean.getEntityClass());
    }

    public void _get(@RequestParameter(value="p") Integer p) {
        this.index(p);
    }

    protected void index(Integer p) {
        if (p == null) {
            p = 1;
        }
        ConditionBean cb = this.entityBean.newConditionBean();
        cb.paging(this.entityBean.getRecordsByPage(), p.intValue());
        PagingResultBean bean = this.entityBean.getBehavior().readPage(cb);
        this.view.setResultBean((PagingResultBean<? extends Entity>)bean);
        this.sessionManager.setAttribute(this.getSessionKey("p"), (Object)p);
    }

    public void _get_returned() {
        this.index((Integer)this.sessionManager.getAttribute(this.getSessionKey("p")));
    }

    public void _get_add() {
    }

    public Response _post_do_add() {
        String modifiedDateColumnName;
        Date now = new Date();
        String createdDateColumnName = this.entityBean.getCreatedDateColumnName();
        if (createdDateColumnName != null) {
            this.scopeManager.populateQuietly((Object)this.entity, createdDateColumnName, (Object)now);
        }
        if ((modifiedDateColumnName = this.entityBean.getModifiedDateColumnName()) != null) {
            this.scopeManager.populateQuietly((Object)this.entity, modifiedDateColumnName, (Object)now);
        }
        this.entityBean.getBehavior().create(this.entity);
        return Redirect.to("index.html", "returned", new Object[0]);
    }

    public void _get_edit() {
    }

    public Response _post_do_edit() {
        String modifiedDateColumnName = this.entityBean.getModifiedDateColumnName();
        if (modifiedDateColumnName != null) {
            this.scopeManager.populateQuietly((Object)this.entity, modifiedDateColumnName, (Object)new Date());
        }
        this.entityBean.getBehavior().modify(this.entity);
        return Redirect.to("index.html", "returned", new Object[0]);
    }

    public Response _get_do_delete() {
        this.entityBean.getBehavior().remove(this.entity);
        return Redirect.to("index.html", "returned", new Object[0]);
    }

    public Response _post_cancel() {
        return Redirect.to("index.html", "returned", new Object[0]);
    }

    public ViewDto getView() {
        return this.view;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public ColumnInfo getColumnInfo(String columnName) {
        return this.entityBean.getColumnInfo(columnName);
    }
}

