/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

public class AnalyzerUtils {
    private AnalyzerUtils() {
    }

    public static boolean isValidVariableName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        char ch = name.charAt(0);
        if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_')) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            ch = name.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean shouldGeneratePropertyForParameter(String name) {
        int idx;
        if (name == null || name.startsWith("org.seasar.ymir.")) {
            return false;
        }
        int pre = 0;
        while ((idx = name.indexOf(46, pre)) >= 0) {
            if (!AnalyzerUtils.shouldGeneratePropertyForParameterSegment(name.substring(pre, idx))) {
                return false;
            }
            pre = idx + 1;
        }
        return AnalyzerUtils.shouldGeneratePropertyForParameterSegment(name.substring(pre));
    }

    public static boolean shouldGeneratePropertyForParameterSegment(String name) {
        if (name == null) {
            return false;
        }
        if (name.endsWith("]")) {
            int lbracket = name.indexOf(91);
            if (lbracket < 0) {
                return false;
            }
            name = name.substring(0, lbracket);
        }
        return AnalyzerUtils.isValidVariableName(name);
    }
}

