/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.extension.creator.AnnotatedDesc;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassType;
import org.seasar.ymir.extension.creator.Desc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.MethodDescKey;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.impl.AbstractAnnotatedDesc;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescImpl
extends AbstractAnnotatedDesc
implements ClassDesc {
    private DescPool pool_;
    private String name_;
    private String qualifier_;
    private ClassType type_;
    private String superclassName_;
    private boolean abstract_;
    private TypeDesc[] interfaceTypeDescs_ = new TypeDesc[0];
    private Map<String, PropertyDesc> propertyDescMap_ = new LinkedHashMap<String, PropertyDesc>();
    private Map<MethodDescKey, MethodDesc> methodDescMap_ = new LinkedHashMap<MethodDescKey, MethodDesc>();
    private Map<String, Object> parameter_ = new HashMap<String, Object>();
    private String bornOf_;
    private Desc<?> parent_;

    public ClassDescImpl(DescPool pool, String name) {
        this(pool, name, null);
    }

    public ClassDescImpl(DescPool pool, String name, String qualifier) {
        this.pool_ = pool;
        this.name_ = name;
        this.qualifier_ = qualifier;
        this.type_ = ClassType.typeOfClass(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name_ == null ? 0 : this.name_.hashCode());
        result = 31 * result + (this.pool_ == null ? 0 : this.pool_.hashCode());
        result = 31 * result + (this.qualifier_ == null ? 0 : this.qualifier_.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassDescImpl other = (ClassDescImpl)obj;
        if (this.name_ == null ? other.name_ != null : !this.name_.equals(other.name_)) {
            return false;
        }
        if (this.pool_ == null ? other.pool_ != null : !this.pool_.equals(other.pool_)) {
            return false;
        }
        return !(this.qualifier_ == null ? other.qualifier_ != null : !this.qualifier_.equals(other.qualifier_));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name_);
        if (this.qualifier_ != null) {
            sb.append(" (").append(this.qualifier_).append(")");
        }
        return sb.toString();
    }

    @Override
    public DescPool getDescPool() {
        return this.pool_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getQualifier() {
        return this.qualifier_;
    }

    public void setQualifier(String qualifier) {
        if (this.equals(this.qualifier_, qualifier)) {
            return;
        }
        boolean registered = this.pool_.unregisterClassDesc(this);
        this.qualifier_ = qualifier;
        if (registered) {
            this.pool_.registerClassDesc(this);
        }
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    @Override
    public ClassType getType() {
        return this.type_;
    }

    @Override
    public boolean isTypeOf(ClassType type) {
        return type == this.getType();
    }

    @Override
    public TypeDesc[] getInterfaceTypeDescs() {
        return this.interfaceTypeDescs_;
    }

    @Override
    public void setInterfaceTypeDescs(TypeDesc ... interfaceTypeDescs) {
        for (TypeDesc interfaceTypeDesc : this.interfaceTypeDescs_ = interfaceTypeDescs) {
            interfaceTypeDesc.setParent(this);
        }
    }

    @Override
    public PropertyDesc addPropertyDesc(String name, int mode) {
        PropertyDesc propertyDesc = this.getPropertyDesc(name);
        if (propertyDesc == null) {
            propertyDesc = this.pool_.newPropertyDesc(name);
            propertyDesc.setParent(this);
            this.propertyDescMap_.put(name, propertyDesc);
        }
        propertyDesc.addMode(mode);
        return propertyDesc;
    }

    @Override
    public PropertyDesc getPropertyDesc(String name) {
        return this.propertyDescMap_.get(name);
    }

    @Override
    public void setPropertyDesc(PropertyDesc propertyDesc) {
        if (propertyDesc.getDescPool() != this.pool_) {
            throw new IllegalArgumentException("Can't set PropertyDesc born from another DescPool");
        }
        propertyDesc.setParent(this);
        this.propertyDescMap_.put(propertyDesc.getName(), propertyDesc);
    }

    @Override
    public void removePropertyDesc(String name) {
        this.propertyDescMap_.remove(name);
    }

    @Override
    public PropertyDesc[] getPropertyDescs() {
        return this.propertyDescMap_.values().toArray(new PropertyDesc[0]);
    }

    @Override
    public PropertyDesc[] getPropertyDescsOrderByName() {
        PropertyDesc[] pds = this.getPropertyDescs();
        Arrays.sort(pds, new Comparator<PropertyDesc>(){

            @Override
            public int compare(PropertyDesc o1, PropertyDesc o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return pds;
    }

    @Override
    public MethodDesc[] getMethodDescs(String name) {
        ArrayList<MethodDesc> list = new ArrayList<MethodDesc>();
        for (MethodDesc methodDesc : this.methodDescMap_.values()) {
            if (!methodDesc.getName().equals(name)) continue;
            list.add(methodDesc);
        }
        return list.toArray(new MethodDesc[0]);
    }

    @Override
    public MethodDesc getMethodDesc(MethodDesc methodDesc) {
        return this.methodDescMap_.get(new MethodDescKey(methodDesc));
    }

    @Override
    public void setMethodDesc(MethodDesc methodDesc) {
        methodDesc.setParent(this);
        this.methodDescMap_.put(new MethodDescKey(methodDesc), methodDesc);
    }

    @Override
    public MethodDesc[] getMethodDescs() {
        return this.methodDescMap_.values().toArray(new MethodDesc[0]);
    }

    @Override
    public MethodDesc[] getMethodDescsOrderByName() {
        MethodDesc[] mds = this.getMethodDescs();
        Arrays.sort(mds, new Comparator<MethodDesc>(){

            @Override
            public int compare(MethodDesc o1, MethodDesc o2) {
                return new MethodDescKey(o1).compareTo(new MethodDescKey(o2));
            }
        });
        return mds;
    }

    @Override
    public void removeMethodDesc(MethodDesc methodDesc) {
        this.methodDescMap_.remove(new MethodDescKey(methodDesc));
    }

    @Override
    public String getSuperclassName() {
        return this.superclassName_;
    }

    @Override
    public void setSuperclassName(String superclassName) {
        if (Object.class.getName().equals(superclassName)) {
            superclassName = null;
        }
        this.superclassName_ = superclassName;
    }

    @Override
    public String getSuperclassShortName() {
        this.getTouchedClassNameSet().add(this.superclassName_);
        return ClassUtils.getShortName((String)this.superclassName_);
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    @Override
    public void setAbstract(boolean isAbstract) {
        this.abstract_ = isAbstract;
    }

    @Override
    public void merge(ClassDesc classDesc, boolean force) {
        if (classDesc == null) {
            return;
        }
        if (classDesc.getSuperclassName() != null && (force || this.superclassName_ == null)) {
            this.setSuperclassName(classDesc.getSuperclassName());
        }
        if (force) {
            this.setAbstract(classDesc.isAbstract());
        }
        LinkedHashSet<TypeDesc> interfaceTypeDescSet = new LinkedHashSet<TypeDesc>();
        interfaceTypeDescSet.addAll(Arrays.asList(this.interfaceTypeDescs_));
        interfaceTypeDescSet.addAll(Arrays.asList(classDesc.getInterfaceTypeDescs()));
        this.setInterfaceTypeDescs(interfaceTypeDescSet.toArray(new TypeDesc[0]));
        for (PropertyDesc propertyDesc : classDesc.getPropertyDescs()) {
            PropertyDesc pd = this.getPropertyDesc(propertyDesc.getName());
            if (pd == null) {
                this.setPropertyDesc(propertyDesc.transcriptTo(this.pool_.newPropertyDesc(propertyDesc.getName())));
                continue;
            }
            DescUtils.merge(pd, propertyDesc, force);
        }
        for (AnnotatedDesc<PropertyDesc> annotatedDesc : classDesc.getMethodDescs()) {
            MethodDesc md = this.getMethodDesc((MethodDesc)annotatedDesc);
            if (md == null) {
                this.setMethodDesc((MethodDesc)((Object)annotatedDesc.transcriptTo((PropertyDesc)((Object)this.pool_.newMethodDesc(annotatedDesc.getName())))));
                continue;
            }
            DescUtils.merge(md, annotatedDesc, force);
        }
        this.setAnnotationDescs(DescUtils.merge(this.getAnnotationDescs(), classDesc.getAnnotationDescs(), force));
        DescUtils.mergeAttributes(this.getAttributeMap(), classDesc.getAttributeMap(), force);
    }

    @Override
    public void removeBornOf(String bornOf) {
        if (bornOf == null || bornOf.startsWith("request:")) {
            return;
        }
        for (PropertyDesc propertyDesc : this.getPropertyDescs()) {
            if (!propertyDesc.removeBornOf(bornOf)) continue;
            this.removePropertyDesc(propertyDesc.getName());
        }
        for (AnnotatedDesc<PropertyDesc> annotatedDesc : this.getMethodDescs()) {
            if (!annotatedDesc.removeBornOf(bornOf)) continue;
            this.removeMethodDesc((MethodDesc)annotatedDesc);
        }
        DescUtils.removeBornOfFromAttributes(bornOf, this.getAttributeMap());
    }

    @Override
    public boolean isEmpty() {
        return this.propertyDescMap_.isEmpty() && this.methodDescMap_.isEmpty();
    }

    @Override
    public void clear() {
        super.clear();
        this.parameter_.clear();
        this.interfaceTypeDescs_ = new TypeDesc[0];
        this.propertyDescMap_.clear();
        this.methodDescMap_.clear();
    }

    @Override
    public void setPropertyDescs(PropertyDesc ... propertyDescs) {
        this.propertyDescMap_.clear();
        for (PropertyDesc propertyDesc : propertyDescs) {
            this.setPropertyDesc(propertyDesc);
        }
    }

    @Override
    public void setMethodDescs(MethodDesc ... methodDescs) {
        this.methodDescMap_.clear();
        for (MethodDesc methodDesc : methodDescs) {
            this.setMethodDesc(methodDesc);
        }
    }

    @Override
    public String getPathOfClass() {
        return YmirContext.getYmir().getPathOfPageClass(this.getName());
    }

    @Override
    public String getShortName() {
        this.getTouchedClassNameSet().add(this.getName());
        return ClassUtils.getShortName((String)this.getName());
    }

    @Override
    public String getNameBase() {
        return this.getNameBase(this.getName());
    }

    String getNameBase(String name) {
        name = ClassUtils.getShortName((String)name);
        return name.substring(0, name.length() - this.getType().getSuffix().length());
    }

    @Override
    public String getPackageName() {
        return this.getPackageName(this.getName());
    }

    String getPackageName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return "";
        }
        return name.substring(0, dot);
    }

    @Override
    public String getInstanceName() {
        return this.getInstanceName(this.getName());
    }

    String getInstanceName(String name) {
        String instanceName = this.uncapFirst(ClassUtils.getShorterName((String)name));
        if (instanceName.equals(name)) {
            instanceName = instanceName + "Value";
        }
        return instanceName;
    }

    String uncapFirst(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    @Override
    public Map<String, Object> getSourceGeneratorParameter() {
        return this.parameter_;
    }

    @Override
    public void setSourceGeneratorParameter(Map<String, Object> parameter) {
        this.parameter_ = new HashMap<String, Object>(parameter);
    }

    @Override
    public String getBornOf() {
        return this.bornOf_;
    }

    @Override
    public void setBornOf(String bornOf) {
        this.bornOf_ = bornOf;
    }

    @Override
    public ClassDesc transcriptTo(ClassDesc desc) {
        DescPool pool = desc.getDescPool();
        super.transcriptTo(desc);
        desc.setSuperclassName(this.superclassName_);
        desc.setAbstract(this.abstract_);
        ArrayList<TypeDesc> list = new ArrayList<TypeDesc>();
        for (TypeDesc interfaceTypeDesc : this.interfaceTypeDescs_) {
            list.add(interfaceTypeDesc.transcriptTo(pool.newTypeDesc(interfaceTypeDesc)));
        }
        desc.setInterfaceTypeDescs(list.toArray(new TypeDesc[0]));
        for (PropertyDesc propertyDesc : this.propertyDescMap_.values()) {
            desc.setPropertyDesc(propertyDesc.transcriptTo(pool.newPropertyDesc(propertyDesc.getName())));
        }
        for (MethodDesc methodDesc : this.methodDescMap_.values()) {
            desc.setMethodDesc(methodDesc.transcriptTo(pool.newMethodDesc(methodDesc.getName())));
        }
        desc.setSourceGeneratorParameter(this.parameter_);
        desc.setBornOf(this.bornOf_);
        return desc;
    }

    @Override
    public <D extends Desc<?>> D getParent() {
        return (D)this.parent_;
    }

    @Override
    public void setParent(Desc<?> parent) {
        this.parent_ = parent;
    }

    @Override
    public void addDependingClassNamesTo(Set<String> set) {
        this.addDependingClassNamesTo0(set);
        if (this.superclassName_ != null) {
            set.add(this.superclassName_);
        }
        for (TypeDesc interfaceTypeDesc : this.interfaceTypeDescs_) {
            interfaceTypeDesc.addDependingClassNamesTo(set);
        }
        for (PropertyDesc propertyDesc : this.propertyDescMap_.values()) {
            propertyDesc.addDependingClassNamesTo(set);
        }
        for (MethodDesc methodDesc : this.methodDescMap_.values()) {
            methodDesc.addDependingClassNamesTo(set);
        }
    }

    @Override
    public void setTouchedClassNameSet(Set<String> set) {
        if (this.setTouchedClassNameSet0(set)) {
            return;
        }
        for (TypeDesc interfaceTypeDesc : this.interfaceTypeDescs_) {
            interfaceTypeDesc.setTouchedClassNameSet(set);
        }
        for (PropertyDesc propertyDesc : this.propertyDescMap_.values()) {
            propertyDesc.setTouchedClassNameSet(set);
        }
        for (MethodDesc methodDesc : this.methodDescMap_.values()) {
            methodDesc.setTouchedClassNameSet(set);
        }
    }

    @Override
    public String toShortName(String className) {
        this.getTouchedClassNameSet().add(className);
        return ClassUtils.getShortName((String)className);
    }
}

