/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import net.skirnir.freyja.ExpressionEvaluator;
import net.skirnir.freyja.TagEvaluator;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.TemplateEvaluator;
import net.skirnir.freyja.VariableResolver;
import net.skirnir.freyja.impl.TemplateEvaluatorImpl;
import net.skirnir.freyja.impl.VariableResolverImpl;
import net.skirnir.freyja.zpt.MetalTagEvaluator;
import net.skirnir.freyja.zpt.tales.NoteLocalizer;
import net.skirnir.freyja.zpt.tales.PathResolver;
import net.skirnir.freyja.zpt.tales.TalesExpressionEvaluator;
import net.skirnir.freyja.zpt.tales.TypePrefixHandler;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.Response;
import org.seasar.ymir.ResponseCreator;
import org.seasar.ymir.extension.zpt.NoteLocalizerImpl;
import org.seasar.ymir.response.SelfContainedResponse;
import org.seasar.ymir.util.ResponseUtils;
import org.seasar.ymir.zpt.EvalTypePrefixHandler;
import org.seasar.ymir.zpt.YmirPathResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZptResponseCreator
implements ResponseCreator {
    private static final String TEMPLATE_PREFIX = "template/";
    private static final String TEMPLATE_SUFFIX = ".zpt";
    private ApplicationManager applicationManager_;
    private final TemplateEvaluator evaluator_ = new TemplateEvaluatorImpl((TagEvaluator)new MetalTagEvaluator(), (ExpressionEvaluator)new TalesExpressionEvaluator().addTypePrefix("eval", (TypePrefixHandler)new EvalTypePrefixHandler()).addPathResolver((PathResolver)new YmirPathResolver().setNoteLocalizer((NoteLocalizer)new NoteLocalizerImpl())));

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    public Response createResponse(String templateName, Map<String, Object> variableMap) {
        return this.createResponse(this.getURL(templateName), variableMap);
    }

    public Response createResponse(URL templateURL, Map<String, Object> variableMap) {
        TemplateContext context = this.evaluator_.newContext();
        context.setProperty("content-type", "text/html");
        if (variableMap != null) {
            VariableResolverImpl resolver = new VariableResolverImpl();
            for (Map.Entry<String, Object> entry : variableMap.entrySet()) {
                resolver.setVariable(entry.getKey(), entry.getValue());
            }
            context.setVariableResolver((VariableResolver)resolver);
        }
        try {
            SelfContainedResponse response = new SelfContainedResponse(this.evaluator_.evaluate(context, (Reader)new InputStreamReader(templateURL.openStream(), "UTF-8")), "text/html; charset=" + this.getEncoding());
            ResponseUtils.setNoCache((Response)response);
            return response;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    String getEncoding() {
        return this.applicationManager_.findContextApplication().getTemplateEncoding();
    }

    public String evaluateTemplate(String templateName, Map<String, Object> variableMap) {
        return this.evaluateTemplate(this.getURL(templateName), variableMap);
    }

    protected URL getURL(String templateName) {
        return this.getClass().getResource(TEMPLATE_PREFIX + templateName + TEMPLATE_SUFFIX);
    }

    public String evaluateTemplate(URL templateURL, Map<String, Object> variableMap) {
        TemplateContext context = this.evaluator_.newContext();
        context.setProperty("content-type", "text/html");
        if (variableMap != null) {
            VariableResolverImpl resolver = new VariableResolverImpl();
            for (Map.Entry<String, Object> entry : variableMap.entrySet()) {
                resolver.setVariable(entry.getKey(), entry.getValue());
            }
            context.setVariableResolver((VariableResolver)resolver);
        }
        try {
            return this.evaluator_.evaluate(context, (Reader)new InputStreamReader(templateURL.openStream(), "UTF-8"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

