/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.Desc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.extension.creator.util.type.Token;
import org.seasar.ymir.extension.creator.util.type.TokenVisitor;
import org.seasar.ymir.extension.creator.util.type.TypeToken;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescImpl
implements TypeDesc {
    private DescPool pool_;
    private String name_;
    private ClassDesc componentClassDesc_;
    private boolean collection_;
    private String collectionClassName_;
    private String collectionImplementationClassName_;
    private boolean explicit_;
    private Desc<?> parent_;

    public TypeDescImpl(DescPool pool, Type type) {
        this(pool, DescUtils.toString(type));
    }

    public TypeDescImpl(DescPool pool, ClassDesc classDesc) {
        this(pool, classDesc.getName());
    }

    public TypeDescImpl(DescPool pool, String typeName) {
        this.pool_ = pool;
        this.setName(typeName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collectionClassName_ == null ? 0 : this.collectionClassName_.hashCode());
        result = 31 * result + (this.collectionImplementationClassName_ == null ? 0 : this.collectionImplementationClassName_.hashCode());
        result = 31 * result + (this.collection_ ? 1231 : 1237);
        result = 31 * result + (this.componentClassDesc_ == null ? 0 : this.componentClassDesc_.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeDescImpl other = (TypeDescImpl)obj;
        if (this.collectionClassName_ == null ? other.collectionClassName_ != null : !this.collectionClassName_.equals(other.collectionClassName_)) {
            return false;
        }
        if (this.collectionImplementationClassName_ == null ? other.collectionImplementationClassName_ != null : !this.collectionImplementationClassName_.equals(other.collectionImplementationClassName_)) {
            return false;
        }
        if (this.collection_ != other.collection_) {
            return false;
        }
        return !(this.componentClassDesc_ == null ? other.componentClassDesc_ != null : !this.componentClassDesc_.equals(other.componentClassDesc_));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public DescPool getDescPool() {
        return this.pool_;
    }

    @Override
    public ClassDesc getComponentClassDesc() {
        return this.componentClassDesc_;
    }

    @Override
    public void setComponentClassDesc(ClassDesc classDesc) {
        this.componentClassDesc_ = classDesc;
        this.componentClassDesc_.setParent(this);
        this.name_ = null;
    }

    @Override
    public void setComponentClassDesc(Class<?> clazz) {
        this.setComponentClassDesc(this.pool_.getClassDesc(clazz));
    }

    @Override
    public void setName(String typeName) {
        String componentClassName;
        this.componentClassDesc_ = null;
        this.collectionClassName_ = null;
        this.collection_ = DescUtils.isArray(typeName);
        this.name_ = DescUtils.normalizePackage(typeName.replace('$', '.'));
        typeName = DescUtils.complementPackage(typeName);
        if (this.collection_) {
            componentClassName = DescUtils.getComponentName(typeName.replace('$', '.'));
        } else {
            TypeToken token = new TypeToken(typeName);
            Class<?> clazz = this.pool_ != null ? this.pool_.getSourceCreator().getClass(token.getBaseName()) : DescUtils.findClass(token.getBaseName());
            if (clazz != null) {
                this.collection_ = Collection.class.isAssignableFrom(clazz);
            }
            if (this.collection_) {
                this.collectionClassName_ = token.getBaseName();
                TypeToken[] types = token.getTypes();
                componentClassName = types.length == 0 ? Object.class.getName() : types[0].getBaseName();
            } else {
                componentClassName = typeName;
            }
        }
        String className = DescUtils.getNonGenericClassName(componentClassName);
        this.componentClassDesc_ = this.pool_.getClassDesc(className);
        this.componentClassDesc_.setParent(this);
    }

    @Override
    public boolean isCollection() {
        return this.collection_;
    }

    @Override
    public void setCollection(boolean collection) {
        this.collection_ = collection;
        this.name_ = null;
    }

    @Override
    public String getCollectionClassName() {
        return this.collectionClassName_;
    }

    @Override
    public void setCollectionClassName(String collectionClassName) {
        this.collectionClassName_ = collectionClassName;
        this.name_ = null;
    }

    @Override
    public void setCollectionClass(Class<?> collectionClass) {
        this.setCollectionClassName(collectionClass != null ? collectionClass.getName() : null);
    }

    @Override
    public String getCollectionImplementationClassName() {
        return this.collectionImplementationClassName_;
    }

    @Override
    public void setCollectionImplementationClassName(String collectionImplementationClassName) {
        this.collectionImplementationClassName_ = collectionImplementationClassName;
    }

    @Override
    public void setCollectionImplementationClass(Class<?> collectionImplementationClass) {
        this.setCollectionImplementationClassName(collectionImplementationClass != null ? collectionImplementationClass.getName() : null);
    }

    @Override
    public boolean isExplicit() {
        return this.explicit_;
    }

    @Override
    public void setExplicit(boolean explicit) {
        this.explicit_ = explicit;
    }

    @Override
    public boolean isGeneric() {
        if (this.name_ != null) {
            return this.name_.indexOf(60) >= 0;
        }
        return false;
    }

    @Override
    public String getCompleteName() {
        if (this.name_ != null) {
            return this.name_;
        }
        StringBuilder sb = new StringBuilder();
        if (this.collection_ && this.collectionClassName_ != null) {
            sb.append(this.collectionClassName_).append("<");
        }
        sb.append(this.componentClassDesc_.getName());
        if (this.collection_) {
            if (this.collectionClassName_ != null) {
                sb.append(">");
            } else {
                sb.append("[]");
            }
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        if (this.name_ != null) {
            return DescUtils.normalizePackage(this.name_);
        }
        StringBuilder sb = new StringBuilder();
        if (this.collection_ && this.collectionClassName_ != null) {
            sb.append(DescUtils.normalizePackage(this.collectionClassName_)).append("<");
        }
        sb.append(DescUtils.normalizePackage(this.componentClassDesc_.getName()));
        if (this.collection_) {
            if (this.collectionClassName_ != null) {
                sb.append(">");
            } else {
                sb.append("[]");
            }
        }
        return sb.toString();
    }

    @Override
    public String getShortName() {
        if (this.name_ != null) {
            return this.getShortTypeName(this.name_);
        }
        StringBuilder sb = new StringBuilder();
        if (this.collection_ && this.collectionClassName_ != null) {
            sb.append(ClassUtils.getShortName((String)this.collectionClassName_)).append("<");
        }
        sb.append(this.componentClassDesc_.getShortName());
        if (this.collection_) {
            if (this.collectionClassName_ != null) {
                sb.append(">");
            } else {
                sb.append("[]");
            }
        }
        return sb.toString();
    }

    @Override
    public String getShortClassName() {
        if (this.name_ != null) {
            return this.getShortClassName(this.name_);
        }
        if (this.collection_ && this.collectionClassName_ != null) {
            return ClassUtils.getShortName((String)this.collectionClassName_);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.componentClassDesc_.getShortName());
        if (this.collection_) {
            sb.append("[]");
        }
        return sb.toString();
    }

    String getShortTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        return this.getTypeTokenForShorten(typeName).getAsString();
    }

    String getShortClassName(String typeName) {
        if (typeName == null) {
            return null;
        }
        return this.getTypeTokenForShorten(typeName).getBaseName();
    }

    TypeToken getTypeTokenForShorten(String typeName) {
        TypeToken typeToken = new TypeToken(typeName);
        typeToken.accept(new TokenVisitor<Object>(){

            public Object visit(Token acceptor) {
                acceptor.setBaseName(ClassUtils.getShortName((String)acceptor.getBaseName()));
                return null;
            }
        });
        return typeToken;
    }

    @Override
    public String[] getImportClassNames() {
        if (this.name_ != null) {
            return this.getImportClassNames(this.name_);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.componentClassDesc_.getName());
        if (this.collection_ && this.collectionClassName_ != null) {
            list.add(this.collectionClassName_);
        }
        return list.toArray(new String[0]);
    }

    String[] getImportClassNames(String typeName) {
        if (typeName == null) {
            return new String[0];
        }
        final TreeSet importClassNameList = new TreeSet();
        TypeToken typeToken = new TypeToken(typeName);
        typeToken.accept(new TokenVisitor<Object>(){

            public Object visit(Token acceptor) {
                String baseName = acceptor.getBaseName();
                if (baseName.indexOf(46) >= 0) {
                    importClassNameList.add(DescUtils.getComponentName(baseName));
                }
                return null;
            }
        });
        return importClassNameList.toArray(new String[0]);
    }

    @Override
    public String getDefaultValue() {
        if (this.collection_) {
            return String.valueOf((Object)null);
        }
        Object value = ClassUtils.getDefaultValue((String)this.componentClassDesc_.getName());
        if (value instanceof Character) {
            value = (int)((Character)value).charValue();
        } else if (value instanceof Float) {
            value = ((Float)value).intValue();
        }
        return String.valueOf(value);
    }

    @Override
    public String getInstanceName() {
        if (this.collection_) {
            return this.componentClassDesc_.getInstanceName() + "s";
        }
        return this.componentClassDesc_.getInstanceName();
    }

    @Override
    public TypeDesc transcriptTo(TypeDesc desc) {
        DescPool pool = desc.getDescPool();
        if (this.componentClassDesc_ != null) {
            if (this.componentClassDesc_.getDescPool() == pool) {
                desc.setComponentClassDesc(this.componentClassDesc_);
            } else {
                desc.setComponentClassDesc(this.componentClassDesc_.transcriptTo(pool.getClassDesc(this.componentClassDesc_.getName())));
            }
        }
        desc.setCollection(this.collection_);
        desc.setCollectionClassName(this.collectionClassName_);
        desc.setCollectionImplementationClassName(this.collectionImplementationClassName_);
        desc.setExplicit(this.explicit_);
        return desc;
    }

    @Override
    public <D extends Desc<?>> D getParent() {
        return (D)this.parent_;
    }

    @Override
    public void setParent(Desc<?> parent) {
        this.parent_ = parent;
    }
}

