/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.extension.creator.AnnotatedDesc;
import org.seasar.ymir.extension.creator.AnnotationDesc;
import org.seasar.ymir.extension.creator.ClassCreationHintBag;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassDescBag;
import org.seasar.ymir.extension.creator.ClassHint;
import org.seasar.ymir.extension.creator.ClassType;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.PropertyTypeHint;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.Template;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.extension.creator.action.impl.AbstractAction;
import org.seasar.ymir.extension.creator.action.impl.ClassDescDto;
import org.seasar.ymir.extension.creator.action.impl.ClassDto;
import org.seasar.ymir.extension.creator.action.impl.PropertyDto;
import org.seasar.ymir.extension.creator.impl.MetaAnnotationDescImpl;
import org.seasar.ymir.extension.creator.mapping.impl.ActionSelectorSeedImpl;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.extension.creator.util.type.Token;
import org.seasar.ymir.extension.creator.util.type.TokenVisitor;
import org.seasar.ymir.extension.creator.util.type.TypeToken;
import org.seasar.ymir.extension.zpt.ParameterRole;
import org.seasar.ymir.util.BeanUtils;
import org.seasar.ymir.util.ClassUtils;

public class UpdateClassesAction
extends AbstractAction
implements UpdateAction {
    protected static final String PARAM_BUTTON_ALWAYS_SKIP = "__ymir__button_always_skip";
    protected static final String PARAM_APPLY = "__ymir__apply";
    protected static final String PARAMPREFIX_PROPERTYTYPE = "__ymir__propertyType_";
    protected static final String PARAMPREFIX_CONVERTER_PAIRTYPENAME = "__ymir__converter_pairTypeName_";
    protected static final String PARAMPREFIX_CLASSNAME = "__ymir__className_";
    protected static final String PARAMPREFIX_SUPERCLASSNAME = "__ymir__superclassName_";
    protected static final String PARAMPREFIX_PARAMETERROLE = "__ymir__parameterRole_";
    protected static final String PREFIX_CLASSCHECKED = "updateClassesAction.class.checked.";

    public UpdateClassesAction(SourceCreator sourceCreator) {
        super(sourceCreator);
    }

    public Response act(Request request, PathMetaData pathMetaData) {
        if (this.isSkipButtonPushed(request)) {
            return null;
        }
        String subTask = request.getParameter("__ymir__subTask");
        if ("update".equals(subTask)) {
            return this.actUpdate(request, pathMetaData);
        }
        return this.actDefault(request, pathMetaData);
    }

    Response actDefault(Request request, PathMetaData pathMetaData) {
        if (!this.shouldUpdate(request, pathMetaData)) {
            return null;
        }
        ClassDescBag classDescBag = this.getSourceCreator().gatherClassDescs(new PathMetaData[]{pathMetaData});
        if (classDescBag.isEmpty()) {
            return null;
        }
        TreeSet<ClassDto> ambiguousClassSet = new TreeSet<ClassDto>();
        for (ClassDesc cd : classDescBag.getClassDescs()) {
            ClassDto classDto = null;
            for (PropertyDesc pd : cd.getPropertyDescs()) {
                if (!BeanUtils.isAmbiguousPropertyName((String)pd.getName())) continue;
                if (classDto == null) {
                    classDto = new ClassDto(cd.getName());
                    ambiguousClassSet.add(classDto);
                }
                classDto.addProperty(new PropertyDto(pd.getName()));
            }
        }
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("template", pathMetaData.getTemplate());
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("pathMetaData", pathMetaData);
        variableMap.put("createdClassDescs", this.createClassDescDtos(classDescBag.getCreatedClassDescs()));
        variableMap.put("updatedClassDescs", this.createClassDescDtos(classDescBag.getUpdatedClassDescs()));
        variableMap.put("converterCreated", this.getSourceCreatorSetting().isConverterCreationFeatureEnabled());
        variableMap.put("ambiguousClasses", ambiguousClassSet.toArray(new ClassDto[0]));
        return this.getSourceCreator().getResponseCreator().createResponse("updateClasses", variableMap);
    }

    protected ClassDescDto[] createClassDescDtos(ClassDesc[] classDescs) {
        Properties prop = this.getSourceCreator().getSourceCreatorProperties();
        ClassDescDto[] dtos = new ClassDescDto[classDescs.length];
        for (int i = 0; i < classDescs.length; ++i) {
            String name = classDescs[i].getName();
            ClassType type = classDescs[i].getType();
            if (type == ClassType.DAO || type == ClassType.BEAN || type == ClassType.DXO) {
                dtos[i] = new ClassDescDto(classDescs[i], false);
                continue;
            }
            if (type == ClassType.DTO) {
                AnnotationDesc[] ads;
                for (AnnotationDesc ad : ads = DescUtils.newAnnotationDescs(this.getSourceCreator().getClass(classDescs[i].getName() + "Base"))) {
                    if (!AnnotatedDesc.ANNOTATION_NAME_META.equals(ad.getName()) && !AnnotatedDesc.ANNOTATION_NAME_METAS.equals(ad.getName())) continue;
                    classDescs[i].setAnnotationDesc(ad);
                }
            }
            dtos[i] = new ClassDescDto(classDescs[i], PropertyUtils.valueOf((String)prop.getProperty(PREFIX_CLASSCHECKED + name), (boolean)true));
        }
        return dtos;
    }

    Response actUpdate(Request request, PathMetaData pathMetaData) {
        if (request.getParameter(PARAM_BUTTON_ALWAYS_SKIP) != null) {
            this.getSourceCreator().getSourceCreatorSetting().setSourceCreatorEnabledWith(request.getPath(), false);
            return null;
        }
        HttpMethod method = this.getHttpMethod(request);
        if (method == null) {
            return null;
        }
        this.updateMapping(pathMetaData);
        ClassNameMapping classNameMapping = new ClassNameMapping(request.getParameterMap());
        ArrayList<PropertyTypeHint> propertyTypeHintList = new ArrayList<PropertyTypeHint>();
        HashMap<String, ClassHint> classHintMap = new HashMap<String, ClassHint>();
        Iterator itr = request.getParameterNames();
        while (itr.hasNext()) {
            String classAndParameterName;
            String actualClassName;
            int slash;
            String name = (String)itr.next();
            if (name.startsWith(PARAMPREFIX_PROPERTYTYPE)) {
                String classAndPropertyName = name.substring(PARAMPREFIX_PROPERTYTYPE.length());
                slash = classAndPropertyName.indexOf(47);
                if (slash < 0) continue;
                actualClassName = classNameMapping.toActual(classAndPropertyName.substring(0, slash));
                String propertyName = classAndPropertyName.substring(slash + 1);
                String typeName = request.getParameter(name);
                typeName = this.resolveTypeName(typeName, actualClassName);
                propertyTypeHintList.add(new PropertyTypeHint(actualClassName, propertyName, typeName));
                continue;
            }
            if (name.startsWith(PARAMPREFIX_SUPERCLASSNAME)) {
                String className = name.substring(PARAMPREFIX_SUPERCLASSNAME.length());
                String actualClassName2 = classNameMapping.toActual(className);
                String superclassName = this.resolveTypeName(request.getParameter(name), actualClassName2);
                ClassHint classHint = (ClassHint)classHintMap.get(actualClassName2);
                if (classHint == null) {
                    classHint = new ClassHint(actualClassName2);
                    classHintMap.put(actualClassName2, classHint);
                }
                classHint.setSuperclassName(superclassName);
                continue;
            }
            if (!name.startsWith(PARAMPREFIX_PARAMETERROLE) || (slash = (classAndParameterName = name.substring(PARAMPREFIX_PARAMETERROLE.length())).indexOf(47)) < 0) continue;
            actualClassName = classNameMapping.toActual(classAndParameterName.substring(0, slash));
            String parameterName = classAndParameterName.substring(slash + 1);
            ParameterRole role = ParameterRole.valueOf(request.getParameter(name));
            ClassHint classHint = (ClassHint)classHintMap.get(actualClassName);
            if (classHint == null) {
                classHint = new ClassHint(actualClassName);
                classHintMap.put(actualClassName, classHint);
            }
            classHint.setParameterRole(parameterName, role);
        }
        ClassCreationHintBag hintBag = new ClassCreationHintBag(propertyTypeHintList.toArray(new PropertyTypeHint[0]), classHintMap.values().toArray(new ClassHint[0]));
        ClassDescBag classDescBag = this.getSourceCreator().gatherClassDescs(new PathMetaData[]{pathMetaData}, hintBag, null);
        String[] appliedOriginalClassNames = request.getParameterValues(PARAM_APPLY);
        HashSet<String> appliedActualClassNameSet = new HashSet<String>();
        if (appliedOriginalClassNames != null) {
            for (String appliedOriginalClassName : appliedOriginalClassNames) {
                appliedActualClassNameSet.add(classNameMapping.toActual(appliedOriginalClassName));
            }
        }
        Properties prop = this.getSourceCreator().getSourceCreatorProperties();
        ClassDesc[] classDescs = classDescBag.getClassDescs();
        for (int i = 0; i < classDescs.length; ++i) {
            String checked;
            String[] pairTypeNames;
            String actualName = classDescs[i].getName();
            if (classDescs[i].isTypeOf(ClassType.DTO) && (pairTypeNames = this.resolveTypeNames(request.getParameter(PARAMPREFIX_CONVERTER_PAIRTYPENAME + classNameMapping.toOriginal(actualName)), actualName)).length > 0) {
                classDescs[i].setAnnotationDesc(new MetaAnnotationDescImpl("conversion", pairTypeNames, new Class[0]));
            }
            if (appliedActualClassNameSet.contains(actualName)) {
                checked = String.valueOf(true);
            } else {
                checked = String.valueOf(false);
                classDescBag.remove(actualName);
            }
            prop.setProperty(PREFIX_CLASSCHECKED + actualName, checked);
        }
        this.getSourceCreator().saveSourceCreatorProperties();
        this.getSourceCreator().updateClasses(classDescBag);
        boolean successfullySynchronized = this.synchronizeResources(new String[]{this.getRootPackagePath(), this.getPath(pathMetaData.getTemplate())});
        this.pause(1000L);
        this.openJavaCodeInEclipseEditor(pathMetaData.getClassName());
        ClassDesc classDesc = this.getSourceCreator().newClassDesc(this.newDescPool(), pathMetaData.getClassName(), null);
        String path = pathMetaData.getPath();
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("pathMetaData", pathMetaData);
        variableMap.put("classDescBag", classDescBag);
        variableMap.put("actionName", this.getSourceCreator().newActionMethodDesc(classDesc, path, method, new ActionSelectorSeedImpl()).getName());
        variableMap.put("suggestionExists", classDescBag.getClassDescMap(ClassType.PAGE).size() + classDescBag.getCreatedClassDescMap(ClassType.BEAN).size() > 0);
        variableMap.put("pageClassDescs", classDescBag.getClassDescs(ClassType.PAGE));
        variableMap.put("renderActionName", this.getSourceCreator().getExtraPathMapping(path, method).newPrerenderActionMethodDesc(classDesc, new ActionSelectorSeedImpl()).getName());
        variableMap.put("createdBeanClassDescs", classDescBag.getCreatedClassDescs(ClassType.BEAN));
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("updateClasses_update", variableMap);
    }

    String[] resolveTypeNames(String typeNameString, String baseClassName) {
        String[] typeNames = PropertyUtils.toLines((String)typeNameString, (String)",");
        ArrayList<String> list = new ArrayList<String>(typeNames.length);
        for (String typeName : typeNames) {
            list.add(this.resolveTypeName(typeName, baseClassName));
        }
        return list.toArray(new String[0]);
    }

    String resolveTypeName(String typeName, final String baseClassName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.length() == 0) {
            return Object.class.getName();
        }
        TypeToken type = new TypeToken(typeName);
        type.accept(new TokenVisitor<Object>(){

            public Object visit(Token acceptor) {
                String name = DescUtils.getComponentName(acceptor.getBaseName());
                if (name.indexOf(46) < 0 && !ClassUtils.isPrimitive((String)name)) {
                    Class<?> clazz = UpdateClassesAction.this.getSourceCreator().findClass(name, baseClassName);
                    if (clazz == null) {
                        clazz = UpdateClassesAction.this.getSourceCreator().getClass(name);
                    }
                    String className = clazz != null ? clazz.getName() : DescUtils.getPackageName(baseClassName) + "." + name;
                    acceptor.setBaseName(DescUtils.getClassName(className, DescUtils.isArray(acceptor.getBaseName())));
                }
                return null;
            }
        });
        return type.getAsString();
    }

    boolean shouldUpdate(Request request, PathMetaData pathMetaData) {
        Template template = pathMetaData.getTemplate();
        if (template == null || !template.exists()) {
            return false;
        }
        if (request.getParameter("__ymir__task") != null) {
            return true;
        }
        if (this.getSourceCreatorSetting().isTryingToUpdateClassesWhenTemplateModified()) {
            boolean shouldUpdate;
            boolean bl = shouldUpdate = template.lastModified() > this.getSourceCreator().getCheckedTime(template);
            if (shouldUpdate) {
                this.getSourceCreator().updateCheckedTime(template);
            }
            return shouldUpdate;
        }
        return false;
    }

    public static class Hoe
    implements Serializable {
        private List list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassNameMapping {
        private Map<String, String> toActualClassNameMap_ = new HashMap<String, String>();
        private Map<String, String> toOriginalClassNameMap_ = new HashMap<String, String>();

        protected ClassNameMapping(Map<String, String[]> paramMap) {
            this.initialize(paramMap);
        }

        public String toOriginal(String actualClassName) {
            String originalClassName = this.toOriginalClassNameMap_.get(actualClassName);
            if (originalClassName == null) {
                return actualClassName;
            }
            return originalClassName;
        }

        public String toActual(String originalClassName) {
            String actualClassName = this.toActualClassNameMap_.get(originalClassName);
            if (actualClassName == null) {
                return originalClassName;
            }
            return actualClassName;
        }

        void initialize(Map<String, String[]> paramMap) {
            if (paramMap == null) {
                return;
            }
            for (String name : paramMap.keySet()) {
                if (!name.startsWith(UpdateClassesAction.PARAMPREFIX_CLASSNAME)) continue;
                String originalClassName = name.substring(UpdateClassesAction.PARAMPREFIX_CLASSNAME.length());
                String actualClassName = paramMap.get(name)[0];
                if (actualClassName.trim().length() == 0) {
                    actualClassName = originalClassName;
                }
                this.toActualClassNameMap_.put(originalClassName, actualClassName);
                this.toOriginalClassNameMap_.put(actualClassName, originalClassName);
            }
        }
    }
}

