/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.redirection.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.LifecycleListener;
import org.seasar.ymir.Request;
import org.seasar.ymir.redirection.RedirectionManager;
import org.seasar.ymir.redirection.ScopeIdManager;
import org.seasar.ymir.util.StringUtils;
import org.seasar.ymir.window.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedirectionManagerImpl
implements RedirectionManager,
LifecycleListener {
    public static final String ATTRPREFIX_SCOPEMAP = "org.seasar.ymir.redirection.scopeMap.";
    protected ApplicationManager applicationManager_;
    private ScopeIdManager scopeIdManager_;
    private WindowManager windowManager_;

    @Binding(bindingType=BindingType.MUST)
    public final void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setScopeIdManager(ScopeIdManager scopeIdManager) {
        this.scopeIdManager_ = scopeIdManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setWindowManager(WindowManager windowManager) {
        this.windowManager_ = windowManager;
    }

    @Override
    public void init() {
        this.windowManager_.addStraddlingAttributeNamePattern(Pattern.quote(ATTRPREFIX_SCOPEMAP).concat(".*"));
    }

    @Override
    public void destroy() {
    }

    String getScopeMapAttributeKey(String scopeId) {
        return ATTRPREFIX_SCOPEMAP + scopeId;
    }

    Map<String, Object> getScopeMap(String scopeId, boolean create) {
        String key = this.getScopeMapAttributeKey(scopeId);
        HashMap scopeMap = (HashMap)this.windowManager_.getScopeAttribute(key);
        if (scopeMap == null && create) {
            scopeMap = new HashMap();
            this.windowManager_.setScopeAttribute(key, scopeMap);
        }
        return scopeMap;
    }

    void setScopeMap(String windowId, String scopeId, Map<String, Object> scopeMap) {
        this.windowManager_.setScopeAttribute(windowId, this.getScopeMapAttributeKey(scopeId), scopeMap);
    }

    void removeScopeMap(String scopeId) {
        if (scopeId == null) {
            return;
        }
        this.windowManager_.setScopeAttribute(this.getScopeMapAttributeKey(scopeId), null);
    }

    @Override
    public <T> T getScopeAttribute(String name) {
        String scopeId = this.getScopeId();
        if (scopeId == null) {
            return null;
        }
        Map<String, Object> scopeMap = this.getScopeMap(scopeId, false);
        if (scopeMap == null) {
            return null;
        }
        return (T)scopeMap.get(name);
    }

    @Override
    public Iterator<String> getScopeAttributeNames() {
        String scopeId = this.getScopeId();
        if (scopeId == null) {
            return new ArrayList().iterator();
        }
        Map<String, Object> scopeMap = this.getScopeMap(scopeId, false);
        if (scopeMap == null) {
            return new ArrayList().iterator();
        }
        return scopeMap.keySet().iterator();
    }

    @Override
    public String getScopeId() {
        return this.scopeIdManager_.getScopeId();
    }

    @Override
    public void setScopeAttributeForNextRequest(String name, Object value) {
        String scopeId = this.getTemporaryScopeId();
        if (value != null) {
            this.getScopeMap(scopeId, true).put(name, value);
        } else {
            Map<String, Object> scopeMap = this.getScopeMap(scopeId, false);
            if (scopeMap == null) {
                return;
            }
            scopeMap.remove(name);
            if (scopeMap.isEmpty()) {
                this.removeScopeMap(scopeId);
            }
        }
    }

    String getTemporaryScopeId() {
        return StringUtils.getScopeKey(this.getRequest());
    }

    S2Container getS2Container() {
        return this.applicationManager_.findContextApplication().getS2Container();
    }

    Request getRequest() {
        return (Request)this.getS2Container().getComponent(Request.class);
    }

    @Override
    public void clearScopeAttributes() {
        this.removeScopeMap(this.getScopeId());
    }

    @Override
    public void populateScopeId() {
        String temporaryScopeId = this.getTemporaryScopeId();
        Map<String, Object> scopeMap = this.getScopeMap(temporaryScopeId, false);
        String scopeId = this.scopeIdManager_.populateScopeId(scopeMap != null);
        if (scopeMap != null) {
            this.removeScopeMap(temporaryScopeId);
            if (scopeId != null) {
                this.setScopeMap(this.windowManager_.findWindowIdForNextRequest(), scopeId, scopeMap);
            }
        }
    }
}

