/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import java.lang.reflect.AnnotatedElement;
import org.seasar.ymir.annotation.Meta;
import org.seasar.ymir.annotation.Metas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaUtils {
    protected MetaUtils() {
    }

    public static boolean hasMeta(AnnotatedElement element, String name) {
        return MetaUtils.getValue(element, name) != null;
    }

    public static String[] getValue(AnnotatedElement element, String name) {
        if (element == null) {
            return null;
        }
        Meta meta = element.getAnnotation(Meta.class);
        if (meta != null && name.equals(meta.name())) {
            return meta.value();
        }
        Metas metas = element.getAnnotation(Metas.class);
        if (metas != null) {
            for (Meta m : metas.value()) {
                if (!name.equals(m.name())) continue;
                return m.value();
            }
        }
        return null;
    }

    public static String getFirstValue(AnnotatedElement element, String name) {
        String[] value = MetaUtils.getValue(element, name);
        if (value == null || value.length == 0) {
            return null;
        }
        return value[0];
    }

    public static Class<?>[] getClassValue(AnnotatedElement element, String name) {
        if (element == null) {
            return null;
        }
        Meta meta = element.getAnnotation(Meta.class);
        if (meta != null && name.equals(meta.name())) {
            return meta.classValue();
        }
        Metas metas = element.getAnnotation(Metas.class);
        if (metas != null) {
            for (Meta m : metas.value()) {
                if (!name.equals(m.name())) continue;
                return m.classValue();
            }
        }
        return null;
    }

    public static Class<?> getFirstClassValue(AnnotatedElement element, String name) {
        Class<?>[] value = MetaUtils.getClassValue(element, name);
        if (value == null || value.length == 0) {
            return null;
        }
        return value[0];
    }
}

