/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.PageComponentVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageComponentImpl
implements PageComponent {
    private Object page_;
    private Class<?> pageClass_;
    private PageComponent[] children_;
    private PageComponent[] descendants_;

    public PageComponentImpl(Object page, Class<?> pageClass) {
        this(page, pageClass, new PageComponent[0]);
    }

    public PageComponentImpl(Object page, Class<?> pageClass, PageComponent[] children) {
        this.page_ = page;
        this.pageClass_ = pageClass;
        this.setChildren(children);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pageClass_.getName());
        if (this.children_.length > 0) {
            sb.append("[ ");
            for (int i = 0; i < this.children_.length; ++i) {
                sb.append(this.children_.toString());
            }
            sb.append(" ]");
        }
        return sb.toString();
    }

    @Override
    public Object getPage() {
        return this.page_;
    }

    @Override
    public Class<?> getPageClass() {
        return this.pageClass_;
    }

    @Override
    public PageComponent[] getChildren() {
        return this.children_;
    }

    public void setChildren(PageComponent[] children) {
        this.children_ = children;
        this.updateDescendants();
    }

    void updateDescendants() {
        LinkedHashMap<Integer, PageComponent> map = new LinkedHashMap<Integer, PageComponent>();
        this.updateDescendants(this, map);
        this.descendants_ = map.values().toArray(new PageComponent[0]);
    }

    void updateDescendants(PageComponent pageComponent, Map<Integer, PageComponent> map) {
        map.put(System.identityHashCode(pageComponent.getPage()), pageComponent);
        PageComponent[] children = pageComponent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.updateDescendants(children[i], map);
        }
    }

    @Override
    public PageComponent[] getDescendants() {
        return this.descendants_;
    }

    @Override
    public <R> R accept(PageComponentVisitor<?> visitor, Object ... parameters) {
        return (R)visitor.visit(this, parameters);
    }
}

