/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.hotdeploy.impl;

import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.cms.pluggable.util.HotdeployEventUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.ymir.Application;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.hotdeploy.HotdeployEventListener;
import org.seasar.ymir.hotdeploy.HotdeployManager;
import org.seasar.ymir.hotdeploy.fitter.HotdeployFitter;
import org.seasar.ymir.hotdeploy.impl.AbstractHotdeployEventListener;
import org.seasar.ymir.hotdeploy.impl.S2HotdeployEventListenerAdapter;
import org.seasar.ymir.util.ClassUtils;
import org.seasar.ymir.util.ContainerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotdeployManagerImpl
implements HotdeployManager {
    private ApplicationManager applicationManager_;
    private HotdeployFitter<?>[] hotdeployFitters_ = new HotdeployFitter[0];
    private HotdeployEventListener[] hotdeployEventListeners_ = new HotdeployEventListener[0];
    private ThreadLocal<Integer> fitDepth_ = new ThreadLocal();
    private ThreadLocal<Map<Object, Object>> fittedMap_ = new ThreadLocal();
    private static final Log log_ = LogFactory.getLog(HotdeployManagerImpl.class);

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Override
    @Binding(bindingType=BindingType.MAY)
    public void setHotdeployFitters(HotdeployFitter<?>[] hotdeployFitters) {
        this.hotdeployFitters_ = hotdeployFitters;
    }

    @InitMethod
    public void init() {
        this.addEventListener(new AbstractHotdeployEventListener(){

            public void stop() {
                PropertyUtils.clearDescriptors();
                Introspector.flushCaches();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object fit(Object value) {
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("fit: value's class = " + (value != null ? value.getClass().getName() : null)));
        }
        this.enterFit();
        try {
            Object object = this.fit0(value);
            return object;
        }
        finally {
            this.leaveFit();
        }
    }

    private void enterFit() {
        Integer depthObj = this.fitDepth_.get();
        int depth = depthObj == null ? 0 : depthObj;
        if (depth == 0) {
            this.fittedMap_.set(new IdentityHashMap());
        }
        this.fitDepth_.set(++depth);
    }

    private void leaveFit() {
        int depth = this.fitDepth_.get() - 1;
        if (depth == 0) {
            this.fittedMap_.set(null);
            this.fitDepth_.set(null);
        } else {
            this.fitDepth_.set(depth);
        }
    }

    private Object fit0(Object value) {
        Object destination;
        if (value == null) {
            return value;
        }
        Class<?> sourceClass = value.getClass();
        if (this.isImmutable(sourceClass)) {
            return value;
        }
        Map<Object, Object> fittedMap = this.fittedMap_.get();
        if (fittedMap.containsKey(value)) {
            return fittedMap.get(value);
        }
        Class<?> destinationClass = this.getContextClass(sourceClass);
        if (sourceClass == destinationClass) {
            fittedMap.put(value, value);
            if (sourceClass.isArray()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    Object fitted = this.fit0(Array.get(value, i));
                    if (!ClassUtils.isCapable(fitted, sourceClass.getComponentType())) continue;
                    Array.set(value, i, fitted);
                }
            } else {
                HotdeployFitter<?> fitter = this.getHotdeployFitterBag().findFitter(destinationClass);
                if (fitter != null) {
                    fitter.fitContent(value);
                }
            }
            return value;
        }
        if (sourceClass.isArray()) {
            destination = Array.newInstance(destinationClass.getComponentType(), Array.getLength(value));
        } else {
            try {
                if (Enum.class.isAssignableFrom(destinationClass)) {
                    return destinationClass.getField(((Enum)value).name()).get(null);
                }
                destination = destinationClass.newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException("Can't instanciate an object of class: " + destinationClass, t);
            }
        }
        fittedMap.put(value, destination);
        if (sourceClass.isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object fitted = this.fit0(Array.get(value, i));
                if (!ClassUtils.isCapable(fitted, destinationClass.getComponentType())) continue;
                Array.set(destination, i, fitted);
            }
        } else {
            this.fitContent(value, destination);
        }
        return destination;
    }

    private boolean isImmutable(Class<?> clazz) {
        return clazz.isPrimitive() || ClassUtils.isWrapper(clazz) || clazz == String.class || clazz == BigInteger.class || clazz == BigDecimal.class;
    }

    HotdeployFitterBag getHotdeployFitterBag() {
        Application application = this.applicationManager_.findContextApplication();
        HotdeployFitterBag fitterBag = application.getRelatedObject(HotdeployFitterBag.class);
        if (fitterBag == null) {
            fitterBag = new HotdeployFitterBag(ContainerUtils.merge(this.hotdeployFitters_, (HotdeployFitter[])ContainerUtils.findAllComponents((S2Container)application.getS2Container(), HotdeployFitter.class)));
            application.setRelatedObject(HotdeployFitterBag.class, fitterBag);
        }
        return fitterBag;
    }

    void fitContent(Object source, Object destination) {
        Class<?> destinationClass = destination.getClass();
        HashMap<String, Field> sourceFieldMap = new HashMap<String, Field>();
        for (Field field : this.getFields(source.getClass())) {
            sourceFieldMap.put(field.getName(), field);
        }
        for (Field destinationField : this.getFields(destinationClass)) {
            Field sourceField;
            if (Modifier.isFinal(destinationField.getModifiers()) || (sourceField = (Field)sourceFieldMap.get(destinationField.getName())) == null) continue;
            sourceField.setAccessible(true);
            destinationField.setAccessible(true);
            try {
                Object fitted = this.fit0(sourceField.get(source));
                if (!ClassUtils.isCapable(fitted, destinationField.getType())) continue;
                destinationField.set(destination, fitted);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("May logic error", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Can't happen!", ex);
            }
        }
    }

    void fitContent(Object object) {
        for (Field field : this.getFields(object.getClass())) {
            field.setAccessible(true);
            try {
                if (Modifier.isFinal(field.getModifiers())) {
                    this.fit0(field.get(object));
                    continue;
                }
                Object fitted = this.fit0(field.get(object));
                if (!ClassUtils.isCapable(fitted, field.getType())) continue;
                field.set(object, fitted);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("May logic error", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Can't happen!", ex);
            }
        }
    }

    Field[] getFields(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        while (clazz != Object.class) {
            list.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return list.toArray(new Field[0]);
    }

    Class<?> getContextClass(Class<?> clazz) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (clazz.isArray()) {
                return Array.newInstance(contextClassLoader.loadClass(clazz.getComponentType().getName()), 0).getClass();
            }
            return contextClassLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            return clazz;
        }
    }

    @Override
    public void addEventListener(HotdeployEventListener listener) {
        this.hotdeployEventListeners_ = (HotdeployEventListener[])ArrayUtil.add((Object[])this.hotdeployEventListeners_, (Object)listener);
        HotdeployEventUtils.add((org.seasar.cms.pluggable.hotdeploy.HotdeployEventListener)new S2HotdeployEventListenerAdapter(listener));
    }

    @Override
    public HotdeployEventListener[] getEventListeners() {
        return this.hotdeployEventListeners_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HotdeployFitterBag {
        private HotdeployFitter<?>[] fitters_;
        private Map<Class<?>, HotdeployFitter<?>> fitterMap_;

        public HotdeployFitterBag(HotdeployFitter<?>[] fitters) {
            this.fitters_ = fitters;
            this.fitterMap_ = new HashMap();
            for (int i = 0; i < fitters.length; ++i) {
                this.fitterMap_.put(fitters[i].getTargetClass(), fitters[i]);
            }
        }

        HotdeployFitter<?> findFitter(Class<?> clazz) {
            HotdeployFitter<?> fitter = this.fitterMap_.get(clazz);
            if (fitter != null) {
                return fitter;
            }
            for (int i = 0; i < this.fitters_.length; ++i) {
                if (!this.fitters_[i].getTargetClass().isAssignableFrom(clazz)) continue;
                return this.fitters_[i];
            }
            return null;
        }

        public HotdeployFitter<?>[] getFitters() {
            return this.fitters_;
        }
    }
}

