/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.constraint.impl;

import java.lang.reflect.AnnotatedElement;
import org.seasar.ymir.Request;
import org.seasar.ymir.constraint.ConstraintUtils;
import org.seasar.ymir.constraint.ConstraintViolatedException;
import org.seasar.ymir.constraint.ValidationFailedException;
import org.seasar.ymir.constraint.annotation.Length;
import org.seasar.ymir.constraint.impl.AbstractConstraint;
import org.seasar.ymir.message.Note;
import org.seasar.ymir.message.Notes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthConstraint
extends AbstractConstraint<Length> {
    public static final String SUFFIX_DIFFERENT = ".different";
    public static final String SUFFIX_MIN = ".min";
    public static final String SUFFIX_MAX = ".max";

    @Override
    protected String getConstraintKey() {
        return "length";
    }

    @Override
    public void confirm(Object component, Request request, Length annotation, AnnotatedElement element) throws ConstraintViolatedException {
        String[] names = this.getParameterNames(request, this.getPropertyName(element), annotation.property());
        if (names.length == 0) {
            return;
        }
        int max = annotation.max();
        if (max == Integer.MAX_VALUE) {
            max = annotation.value();
        }
        Notes notes = new Notes();
        for (int i = 0; i < names.length; ++i) {
            this.confirm(request, names[i], annotation.min(), max, notes, annotation.messageKey(), annotation.namePrefixOnNote());
        }
        if (notes.size() > 0) {
            throw new ValidationFailedException().setNotes(notes);
        }
    }

    void confirm(Request request, String name, int min, int max, Notes notes, String messageKey, String namePrefixOnNote) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return;
        }
        boolean same = min == max;
        for (int i = 0; i < values.length; ++i) {
            if (values[i].length() == 0) continue;
            String suffix = null;
            int border = 0;
            if (values[i].length() < min) {
                suffix = same ? SUFFIX_DIFFERENT : SUFFIX_MIN;
                border = min;
            } else if (values[i].length() > max) {
                suffix = same ? SUFFIX_DIFFERENT : SUFFIX_MAX;
                border = max;
            }
            if (suffix == null) continue;
            notes.add(name, new Note(ConstraintUtils.getFullMessageKey(this.getConstraintKey() + suffix, messageKey), namePrefixOnNote + name, border));
        }
    }
}

