/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.annotation.handler.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.annotation.ElementAlias;
import org.seasar.ymir.annotation.handler.AnnotationElements;

public class AliasAnnotationInvocationHandler
implements InvocationHandler {
    private static final String PROP_ANNOTATIONTYPE = "annotationType";
    private Annotation aliasAnnotation_;
    private Annotation originalAnnotation_;
    private Map<String, String> elementRealNameToAliasMap_ = new HashMap<String, String>();

    public AliasAnnotationInvocationHandler(Annotation aliasAnnotation, Annotation originalAnnotation) {
        this.aliasAnnotation_ = aliasAnnotation;
        this.originalAnnotation_ = originalAnnotation;
        for (Method method : this.aliasAnnotation_.annotationType().getMethods()) {
            String name = method.getName();
            ElementAlias elementAlias = method.getAnnotation(ElementAlias.class);
            if (elementAlias != null) {
                name = elementAlias.value();
                if (method.getName().equals("z_alias")) {
                    throw new IllegalClientCodeRuntimeException("@ElementAlias annotation cannot annotate 'z_alias' element: " + aliasAnnotation.annotationType().getName());
                }
            }
            if (this.elementRealNameToAliasMap_.put(name, method.getName()) == null) continue;
            throw new IllegalClientCodeRuntimeException("Duplicate name (for element '" + elementAlias.value() + "') specified. Please confirm @ElementAlias annotations: " + this.aliasAnnotation_.annotationType().getName());
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this.originalAnnotation_, args);
        }
        String name = method.getName();
        if (name.equals(PROP_ANNOTATIONTYPE)) {
            return this.originalAnnotation_.annotationType();
        }
        if (name.equals("z_alias")) {
            return AnnotationElements.getPropertyValue(this.originalAnnotation_, name);
        }
        String alias = this.elementRealNameToAliasMap_.get(name);
        if (alias != null) {
            return AnnotationElements.getPropertyValue(this.aliasAnnotation_, alias);
        }
        return AnnotationElements.getPropertyValue(this.originalAnnotation_, name);
    }
}

