/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.constraint.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.Request;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.constraint.ConstraintUtils;
import org.seasar.ymir.constraint.ConstraintViolatedException;
import org.seasar.ymir.constraint.ValidationFailedException;
import org.seasar.ymir.constraint.annotation.FittedOnType;
import org.seasar.ymir.constraint.impl.AbstractConstraint;
import org.seasar.ymir.converter.PropertyHandler;
import org.seasar.ymir.converter.TypeConversionException;
import org.seasar.ymir.converter.TypeConversionManager;
import org.seasar.ymir.converter.annotation.TypeConversionHint;
import org.seasar.ymir.message.Messages;
import org.seasar.ymir.message.Note;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FittedOnTypeConstraint
extends AbstractConstraint<FittedOnType> {
    private AnnotationHandler annotationHandler_;
    private Messages messages_;
    private TypeConversionManager typeConversionManager_;

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Binding(bindingType=BindingType.MUST, value="messages")
    public void setMessages(Messages messages) {
        this.messages_ = messages;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setTypeConversionManager(TypeConversionManager typeConversionManager) {
        this.typeConversionManager_ = typeConversionManager;
    }

    @Override
    protected String getConstraintKey() {
        return "fittedOnType";
    }

    @Override
    public void confirm(Object component, Request request, FittedOnType annotation, AnnotatedElement element) throws ConstraintViolatedException {
        Notes notes = new Notes();
        if (element instanceof Class) {
            Object bean;
            Class clazz = (Class)element;
            try {
                bean = clazz.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalClientCodeRuntimeException("Can't add @FittedOnType annotation to a class that has no public default constructor: " + clazz.getName(), t);
            }
            Iterator<String> itr = request.getParameterNames();
            while (itr.hasNext()) {
                String name = itr.next();
                PropertyHandler handler = this.typeConversionManager_.getPropertyHandler(bean, name);
                if (handler == null) continue;
                this.confirm(request, name, handler.getPropertyType(), this.annotationHandler_.getMarkedAnnotations(handler.getWriteMethod(), TypeConversionHint.class), notes, annotation.messageKey(), annotation.namePrefixOnNote());
            }
        } else if (element instanceof Method) {
            this.confirm(request, this.getPropertyName(element), this.getPropertyType(element), this.annotationHandler_.getMarkedAnnotations(element, TypeConversionHint.class), notes, annotation.messageKey(), annotation.namePrefixOnNote());
        } else {
            throw new RuntimeException("May logic error");
        }
        if (notes.size() > 0) {
            throw new ValidationFailedException().setNotes(notes);
        }
    }

    void confirm(Request request, String name, Class<?> type, Annotation[] hint, Notes notes, String messageKey, String namePrefixOnNote) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return;
        }
        for (String value : values) {
            if (value.length() == 0) continue;
            try {
                this.typeConversionManager_.tryToConvert(value, type, hint);
            }
            catch (TypeConversionException ex) {
                String typeName = this.getTypeName(type);
                String constraintKey = this.getConstraintKey() + "." + typeName;
                if ((messageKey == null || messageKey.length() == 0) && this.messages_.getMessage(ConstraintUtils.getFullMessageKey(constraintKey)) == null) {
                    constraintKey = this.getConstraintKey();
                }
                notes.add(name, new Note(ConstraintUtils.getFullMessageKey(constraintKey, messageKey), namePrefixOnNote + name, typeName));
            }
        }
    }

    protected String getTypeName(Class<?> type) {
        if (ClassUtils.isWrapper(type)) {
            type = ClassUtils.toPrimitive(type);
        }
        return ClassUtils.getShortName(ClassUtils.toComponentType(type));
    }
}

