/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.IllegalSyntaxException;
import net.skirnir.freyja.StringUtils;
import net.skirnir.freyja.TagEvaluatorUtils;
import net.skirnir.freyja.zpt.ZptUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TalAttributes {
    private Map<String, Statement> statementMap_ = new LinkedHashMap<String, Statement>();

    public static TalAttributes newInstance() {
        return new TalAttributes();
    }

    public static TalAttributes valueOf(Attribute attribute) throws IllegalSyntaxException {
        if (attribute == null) {
            return null;
        }
        return new TalAttributes(attribute);
    }

    public static TalAttributes valueOf(String defiltered) throws IllegalSyntaxException {
        if (defiltered == null) {
            return null;
        }
        return new TalAttributes(defiltered);
    }

    protected TalAttributes() {
    }

    protected TalAttributes(Attribute attribute) throws IllegalSyntaxException {
        try {
            this.initialize(TagEvaluatorUtils.defilter((String)attribute.getValue()));
        }
        catch (IllegalSyntaxException ex) {
            throw (IllegalSyntaxException)ex.setLineNumber(attribute.getLineNumber()).setColumnNumber(attribute.getColumnNumber());
        }
    }

    protected TalAttributes(String string) throws IllegalSyntaxException {
        this.initialize(string);
    }

    private void initialize(String string) throws IllegalSyntaxException {
        for (String statement : ZptUtils.parseStatements((String)string)) {
            int sp = statement.indexOf(32);
            if (sp < 0) {
                throw new IllegalSyntaxException("Syntax error: " + statement);
            }
            String varname = statement.substring(0, sp).trim();
            if (this.statementMap_.put(varname, new Statement(varname, StringUtils.trimLeft((String)statement.substring(sp + 1)))) == null) continue;
            throw new IllegalSyntaxException("Duplicate variable name found: " + varname);
        }
    }

    public Collection<Statement> getStatements() {
        return this.statementMap_.values();
    }

    public Statement getStatement(String varname) {
        return this.statementMap_.get(varname);
    }

    public void addStatement(String varname, String expression) {
        this.statementMap_.put(varname, new Statement(varname, expression));
    }

    public void removeStatement(String varname) {
        this.statementMap_.remove(varname);
    }

    public String toFilteredString() {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (Statement statement : this.getStatements()) {
            sb.append(delim).append(statement.getVarname()).append(" ").append(statement.getExpression().replace(";", ";;"));
            delim = "; ";
        }
        return TagEvaluatorUtils.filter((String)sb.toString());
    }

    public static class Statement {
        private String varname_;
        private String expression_;

        public Statement(String varname, String expression) {
            this.varname_ = varname;
            this.expression_ = expression;
        }

        public String getVarname() {
            return this.varname_;
        }

        public void setVarname(String varname) {
            this.varname_ = varname;
        }

        public String getExpression() {
            return this.expression_;
        }

        public void setExpression(String expression) {
            this.expression_ = expression;
        }
    }
}

