/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogUtils {
    public static final String INDENT = "  ";
    public static final String DELIM = ", ";
    public static final String LS = System.getProperty("line.separator");

    protected LogUtils() {
    }

    public static String addIndent(Object obj) {
        return LogUtils.addIndent(obj, INDENT);
    }

    public static String addIndent(Object obj, String indent) {
        if (obj == null) {
            return null;
        }
        String text = obj.toString();
        if (text.length() == 0) {
            return text;
        }
        BufferedReader br = new BufferedReader(new StringReader(text));
        StringBuilder sb = new StringBuilder();
        String delim = "";
        String idt = "";
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(delim).append(idt).append(line);
                delim = LS;
                idt = indent;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't happen!", ex);
        }
        char lastChar = text.charAt(text.length() - 1);
        if (lastChar == '\n' || lastChar == '\r') {
            sb.append(LS);
        }
        return sb.toString();
    }

    public static String toString(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (!map.isEmpty()) {
            sb.append(LS);
            for (Object key : LogUtils.toSortedSet(map.keySet())) {
                sb.append(INDENT).append(key).append("=").append(LogUtils.addIndent(map.get(key), INDENT)).append(LS);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public static <V> SortedSet<V> toSortedSet(Collection<V> collection) {
        TreeSet<V> set = new TreeSet<V>();
        set.addAll(collection);
        return set;
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            return LogUtils.toString((Map)obj);
        }
        if (obj.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            String delim = "";
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                sb.append(delim).append(Array.get(obj, i));
                delim = DELIM;
            }
            sb.append("]");
            return sb.toString();
        }
        return obj.toString();
    }
}

