/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.history.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.LifecycleListener;
import org.seasar.ymir.history.History;
import org.seasar.ymir.history.HistoryManager;
import org.seasar.ymir.history.impl.HistoryImpl;
import org.seasar.ymir.window.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryManagerImpl
implements HistoryManager,
LifecycleListener {
    public static final String ATTRPREFIX_HISTORY = "org.seasar.ymir.history.";
    public static final String ATTR_HISTORY = "org.seasar.ymir.history.history";
    private ApplicationManager applicationManager_;
    private WindowManager windowManager_;
    private int recordCount_ = 10;
    private List<Pattern> ignorePathPatterns = new ArrayList<Pattern>();

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setWindowManager(WindowManager windowManager) {
        this.windowManager_ = windowManager;
    }

    @Override
    @Binding(bindingType=BindingType.NONE)
    public void setRecordCount(int recordCount) {
        this.recordCount_ = recordCount;
    }

    @Override
    public void addIgnorePathPatternString(String ignorePathPatternString) {
        this.ignorePathPatterns.add(Pattern.compile(ignorePathPatternString));
    }

    @Override
    public void setIgnorePathPatternStrings(List<String> ignorePathPatternStrings) {
        this.ignorePathPatterns.clear();
        for (String ignorePathPatternString : ignorePathPatternStrings) {
            this.addIgnorePathPatternString(ignorePathPatternString);
        }
    }

    @Override
    public List<Pattern> getIgnorePathPatterns() {
        return this.ignorePathPatterns;
    }

    @Override
    public void init() {
        this.windowManager_.addStraddlingAttributeNamePattern(Pattern.quote(ATTR_HISTORY));
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRecording() {
        Object object = this.monitor();
        synchronized (object) {
            if (!this.isRecording()) {
                this.windowManager_.setScopeAttribute(ATTR_HISTORY, this.newHistory());
            }
        }
    }

    protected HistoryImpl newHistory() {
        return new HistoryImpl(this.recordCount_);
    }

    private Object monitor() {
        return this.windowManager_.findWindowId().intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRecording() {
        Object object = this.monitor();
        synchronized (object) {
            if (this.isAutoRecording()) {
                return this.windowManager_.existsWindowScope();
            }
            return this.windowManager_.getScopeAttribute(ATTR_HISTORY) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public History getHistory() {
        Object object = this.monitor();
        synchronized (object) {
            History history = (History)this.windowManager_.getScopeAttribute(ATTR_HISTORY);
            if (history == null) {
                history = this.newHistory();
                if (this.isAutoRecording() && this.windowManager_.existsWindowScope()) {
                    this.windowManager_.setScopeAttribute(ATTR_HISTORY, history);
                }
            }
            return history;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRecording() {
        Object object = this.monitor();
        synchronized (object) {
            this.windowManager_.setScopeAttribute(ATTR_HISTORY, null);
        }
    }

    boolean isAutoRecording() {
        return PropertyUtils.valueOf((String)this.applicationManager_.findContextApplication().getProperty("core.history.autoRecording"), (boolean)false);
    }
}

