/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.locale.impl;

import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.locale.LocaleManager;
import org.seasar.ymir.session.SessionManager;
import org.seasar.ymir.util.ContainerUtils;

public class LocaleManagerImpl
implements LocaleManager {
    private ApplicationManager applicationManager_;
    private SessionManager sessionManager_;

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager_ = sessionManager;
    }

    public Locale getLocale() {
        return this.findLocale(this.getHttpServletRequest());
    }

    protected Locale findLocale(HttpServletRequest request) {
        if (request != null) {
            Locale locale = (Locale)this.sessionManager_.getAttribute("org.seasar.ymir.locale.locale");
            if (locale == null) {
                locale = request.getLocale();
            }
            return locale;
        }
        return Locale.getDefault();
    }

    HttpServletRequest getHttpServletRequest() {
        return ContainerUtils.getHttpServletRequest((S2Container)this.getS2Container().getRoot());
    }

    public void setLocale(Locale locale) {
        this.sessionManager_.setAttribute("org.seasar.ymir.locale.locale", locale);
    }

    S2Container getS2Container() {
        return this.applicationManager_.findContextApplication().getS2Container();
    }

    public void removeLocale() {
        this.sessionManager_.removeAttribute("org.seasar.ymir.locale.locale");
    }

    public TimeZone getTimeZone() {
        TimeZone timeZone = (TimeZone)this.sessionManager_.getAttribute("org.seasar.ymir.locale.timeZone");
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        return timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.sessionManager_.setAttribute("org.seasar.ymir.locale.timeZone", timeZone);
    }

    public void removeTimeZone() {
        this.sessionManager_.removeAttribute("org.seasar.ymir.locale.timeZone");
    }
}

