/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.render.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.seasar.ymir.util.HTMLUtils;

public class Tag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LS = System.getProperty("line.separator");
    private Object content_;
    private String id_;
    private String styleClass_;
    private String style_;

    public Tag() {
    }

    public Tag(Object content) {
        this.setContent(content);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        this.writeName(sb);
        this.writeAttributes(sb);
        this.writeContent(sb);
        sb.append(">");
        return sb.toString();
    }

    protected void writeName(StringBuilder sb) {
    }

    protected void writeAttributes(StringBuilder sb) {
        if (this.id_ != null) {
            sb.append(" id=\"").append(HTMLUtils.filter(this.id_)).append("\"");
        }
        if (this.styleClass_ != null) {
            sb.append(" class=\"").append(HTMLUtils.filter(this.styleClass_)).append("\"");
        }
        if (this.style_ != null) {
            sb.append(" style=\"").append(HTMLUtils.filter(this.style_)).append("\"");
        }
    }

    protected void writeContent(StringBuilder sb) {
        if (this.content_ != null) {
            sb.append(">");
            if (this.content_ instanceof Tag) {
                sb.append(LS).append("  ").append(this.content_).append(LS);
            } else if (this.content_ instanceof Tag[]) {
                Tag[] tags = (Tag[])this.content_;
                if (tags.length > 0) {
                    for (int i = 0; i < tags.length; ++i) {
                        sb.append(LS).append("  ").append(tags[i]);
                    }
                    sb.append(LS);
                }
            } else {
                sb.append(this.content_);
            }
            sb.append("</");
            this.writeName(sb);
        } else {
            sb.append(" /");
        }
    }

    protected final String addIndent(Object obj) {
        if (obj == null) {
            return null;
        }
        String text = obj.toString();
        if (text.length() == 0) {
            return text;
        }
        BufferedReader br = new BufferedReader(new StringReader(text));
        StringBuilder sb = new StringBuilder();
        String delim = "";
        String idt = "";
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(delim).append(idt).append(line);
                delim = LS;
                idt = "  ";
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't happen!", ex);
        }
        char lastChar = text.charAt(text.length() - 1);
        if (lastChar == '\n' || lastChar == '\r') {
            sb.append(LS);
        }
        return sb.toString();
    }

    public Object getContent() {
        return this.content_;
    }

    public Tag setContent(Object content) {
        this.content_ = content;
        return this;
    }

    public String getContentAsString() {
        if (this.content_ != null) {
            return this.content_.toString();
        }
        return null;
    }

    public String getId() {
        return this.id_;
    }

    public Tag setId(String id) {
        this.id_ = id;
        return this;
    }

    public String getStyleClass() {
        return this.styleClass_;
    }

    public Tag setStyleClass(String styleClass) {
        this.styleClass_ = styleClass;
        return this;
    }

    public String getStyle() {
        return this.style_;
    }

    public Tag setStyle(String style) {
        this.style_ = style;
        return this;
    }
}

