/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.render.html;

import org.seasar.ymir.render.html.Tag;
import org.seasar.ymir.util.HTMLUtils;

public class Input
extends Tag {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_BUTTON = "button";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_HIDDEN = "hidden";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_PASSWORD = "password";
    public static final String TYPE_RADIO = "radio";
    public static final String TYPE_RESET = "reset";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_TEXT = "text";
    private String type_;
    private String name_;
    private String value_;
    private boolean checked_;
    private boolean disabled_;

    public Input() {
    }

    public Input(Object value) {
        this(value, value);
    }

    public Input(Object value, Object content) {
        super(content);
        this.value_ = value != null ? value.toString() : null;
    }

    protected void writeName(StringBuilder sb) {
        sb.append("input");
    }

    protected void writeAttributes(StringBuilder sb) {
        super.writeAttributes(sb);
        if (this.type_ != null) {
            sb.append(" type=\"").append(HTMLUtils.filter(this.type_)).append("\"");
        }
        if (this.name_ != null) {
            sb.append(" name=\"").append(HTMLUtils.filter(this.name_)).append("\"");
        }
        if (this.value_ != null) {
            sb.append(" value=\"").append(HTMLUtils.filter(this.value_)).append("\"");
        }
        if (this.checked_) {
            sb.append(" checked=\"checked\"");
        }
        if (this.disabled_) {
            sb.append(" disabled=\"disabled\"");
        }
    }

    public String getType() {
        return this.type_;
    }

    public Input setType(String type) {
        this.type_ = type;
        return this;
    }

    public String getName() {
        return this.name_;
    }

    public Input setName(String name) {
        this.name_ = name;
        return this;
    }

    public String[] getValue() {
        return new String[]{this.getInputValue()};
    }

    public void setValue(String[] value) {
        if (TYPE_CHECKBOX.equals(this.type_) || TYPE_RADIO.equals(this.type_)) {
            this.checked_ = false;
            for (int i = 0; i < value.length; ++i) {
                if (!value[i].equals(this.value_)) continue;
                this.checked_ = true;
                break;
            }
        } else {
            this.setInputValue(value.length > 0 ? value[0] : null);
        }
    }

    public String getInputValue() {
        return this.value_;
    }

    public Integer getInputValueAsInteger() {
        if (this.value_ == null) {
            return null;
        }
        return Integer.valueOf(this.value_);
    }

    public Input setInputValue(Object value) {
        this.value_ = value != null ? value.toString() : null;
        return this;
    }

    public boolean isDisabled() {
        return this.disabled_;
    }

    public Input setDisabled(boolean disabled) {
        this.disabled_ = disabled;
        return this;
    }

    public boolean isChecked() {
        return this.checked_;
    }

    public Input setChecked(boolean checked) {
        this.checked_ = checked;
        return this;
    }
}

