/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.mock.servlet;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.seasar.ymir.Path;
import org.seasar.ymir.mock.servlet.MockHttpServletRequest;
import org.seasar.ymir.mock.servlet.MockRequestDispatcher;
import org.seasar.ymir.util.ServletUtils;

public class MockRequestDispatcherImpl
extends org.seasar.framework.mock.servlet.MockRequestDispatcherImpl
implements MockRequestDispatcher {
    private String path_;

    public MockRequestDispatcherImpl(String path, HttpServletRequest request) {
        Path p;
        String trunk;
        this.path_ = request == null ? path : ((trunk = (p = new Path(path)).getTrunk()).startsWith("/") ? path : ServletUtils.toAbsolutePath(ServletUtils.getNativePath(request), path));
        if (this.path_.length() == 0) {
            this.path_ = "/";
        }
    }

    public String getPath() {
        return this.path_;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Map parameterMap = request.getParameterMap();
        Path p = new Path(this.path_, request.getCharacterEncoding());
        for (Map.Entry<String, String[]> entry : p.getParameterMap().entrySet()) {
            for (String value : entry.getValue()) {
                ServletUtils.addParameter(entry.getKey(), value, parameterMap, null);
            }
        }
        if (request instanceof MockHttpServletRequest) {
            MockHttpServletRequest req = (MockHttpServletRequest)request;
            req.setAttribute("javax.servlet.forward.context_path", req.getContextPath());
            req.setAttribute("javax.servlet.forward.path_info", req.getPathInfo());
            req.setAttribute("javax.servlet.forward.servlet_path", req.getServletPath());
            req.setAttribute("javax.servlet.forward.query_string", req.getQueryString());
            Path path = new Path(this.path_);
            req.setServletPath(path.getTrunk());
            req.setQueryString(path.getQueryString());
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (request instanceof MockHttpServletRequest) {
            Path path = new Path(this.path_);
            MockHttpServletRequest req = (MockHttpServletRequest)request;
            req.setAttribute("javax.servlet.include.context_path", req.getContextPath());
            req.setAttribute("javax.servlet.include.path_info", null);
            req.setAttribute("javax.servlet.include.servlet_path", path.getTrunk());
            req.setAttribute("javax.servlet.include.query_string", path.getQueryString());
        }
    }
}

