/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.mock.servlet;

import java.util.Enumeration;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Path;
import org.seasar.ymir.mock.servlet.MockHttpServletRequest;
import org.seasar.ymir.mock.servlet.MockHttpSession;
import org.seasar.ymir.mock.servlet.MockHttpSessionImpl;
import org.seasar.ymir.mock.servlet.MockRequestDispatcherFactory;
import org.seasar.ymir.mock.servlet.RequestDispatcherFactory;

public class MockHttpServletRequestImpl
extends org.seasar.framework.mock.servlet.MockHttpServletRequestImpl
implements MockHttpServletRequest {
    private ServletContext servletContext_;
    private String requestPath_;
    private MockHttpSession session_;
    private boolean queryStringApplied_;
    private RequestDispatcherFactory requestDispatcherFactory_ = new MockRequestDispatcherFactory();
    private String servletPath_;

    @Deprecated
    public MockHttpServletRequestImpl(ServletContext servletContext, String requestPath) {
        this(servletContext, "GET", requestPath);
    }

    public MockHttpServletRequestImpl(ServletContext servletContext, HttpMethod method, String requestPath) {
        this(servletContext, method.name(), requestPath);
    }

    public MockHttpServletRequestImpl(ServletContext servletContext, String method, String requestPath) {
        this(servletContext, method, requestPath, null);
    }

    public MockHttpServletRequestImpl(ServletContext servletContext, String method, String requestPath, MockHttpSession session) {
        super(servletContext, new Path(requestPath).getTrunk());
        this.setMethod(method.toUpperCase());
        this.servletContext_ = servletContext;
        this.requestPath_ = requestPath;
        this.session_ = session;
        Path path = new Path(requestPath);
        this.setServletPath(path.getTrunk());
        if (!method.equalsIgnoreCase("POST")) {
            this.setQueryString(path.getQueryString());
        }
    }

    public String getRequestedSessionId() {
        if (this.session_ != null) {
            return this.session_.getId();
        }
        return null;
    }

    public HttpSession getSession(boolean create) {
        if (this.session_ != null) {
            return this.session_;
        }
        if (create) {
            this.session_ = new MockHttpSessionImpl(this.servletContext_, this);
        }
        if (this.session_ != null) {
            this.session_.access();
        }
        return this.session_;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.session_ != null) {
            return this.session_.isValid();
        }
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.session_ != null;
    }

    protected void setSession(MockHttpSession session) {
        this.session_ = session;
    }

    protected void clearSession() {
        this.session_ = null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.requestDispatcherFactory_.newInstance(path, (HttpServletRequest)this);
    }

    public void setRequestDispatcherFactory(RequestDispatcherFactory requestDispatcherFactory) {
        this.requestDispatcherFactory_ = requestDispatcherFactory;
    }

    public String getParameter(String name) {
        if (!this.queryStringApplied_) {
            this.applyQueryString();
        }
        return super.getParameter(name);
    }

    void applyQueryString() {
        this.queryStringApplied_ = true;
        Path path = new Path(this.requestPath_, this.getCharacterEncoding());
        for (Map.Entry<String, String[]> entry : path.getParameterMap().entrySet()) {
            for (String value : entry.getValue()) {
                this.addParameter(entry.getKey(), value);
            }
        }
    }

    public Map getParameterMap() {
        if (!this.queryStringApplied_) {
            this.applyQueryString();
        }
        return super.getParameterMap();
    }

    public Enumeration getParameterNames() {
        if (!this.queryStringApplied_) {
            this.applyQueryString();
        }
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.queryStringApplied_) {
            this.applyQueryString();
        }
        return super.getParameterValues(name);
    }

    public void addParameter(String name, String value) {
        if (!this.queryStringApplied_) {
            this.applyQueryString();
        }
        super.addParameter(name, value);
    }

    public void addParameter(String name, String[] values) {
        if (!this.queryStringApplied_) {
            this.applyQueryString();
        }
        super.addParameter(name, values);
    }

    public void setParameter(String name, String value) {
        if (!this.queryStringApplied_) {
            this.applyQueryString();
        }
        super.setParameter(name, value);
    }

    public void setParameter(String name, String[] values) {
        if (!this.queryStringApplied_) {
            this.applyQueryString();
        }
        super.setParameter(name, values);
    }

    public String getServletPath() {
        return this.servletPath_;
    }

    public void setServletPath(String servletPath) {
        this.servletPath_ = servletPath;
    }
}

