/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.kvasir.util.el.EvaluationException;
import org.seasar.kvasir.util.el.TextTemplateEvaluator;
import org.seasar.kvasir.util.el.VariableResolver;
import org.seasar.kvasir.util.el.impl.MapVariableResolver;
import org.seasar.kvasir.util.el.impl.SimpleTextTemplateEvaluator;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.PageComponentVisitor;
import org.seasar.ymir.PathMapping;
import org.seasar.ymir.Request;
import org.seasar.ymir.util.ClassUtils;
import org.seasar.ymir.util.RegexUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YmirPathMapping
implements PathMapping {
    public static final String KEY_DENIED = "denied";
    public static final String KEY_IGNORED = "ignored";
    public static final String KEY_PATTERN = "pattern";
    public static final String KEY_TEMPLATE = "template";
    public static final String KEY_PAGECOMPONENTNAME_PATTERN = "pageComponentNamePattern";
    public static final String KEY_PAGECOMPONENTNAME_TEMPLATE = "pageComponentNameTemplate";
    public static final String KEY_ACTIONNAME_TEMPLATE = "actionNameTemplate";
    public static final String KEY_PATHINFO_TEMPLATE = "pathInfoTemplate";
    public static final String KEY_PARAMETER_TEMPLATE = "parameterTemplate";
    private static final Pattern PATTERN_PLACEHOLDER = Pattern.compile("\\$\\{[^}]*\\}");
    private static final String PATTRENSTR_PLACEHOLDER_REGEX = ".*";
    public static final String ACTION_PRERENDER = "_prerender";
    public static final String ACTION_DEFAULT = "_default";
    public static final String BUTTONNAME_BASE = "[a-zA-Z_][a-zA-Z_0-9]*";
    public static final String BUTTONNAMEPATTERNSTRINGFORDISPATCHING = "_([a-zA-Z_][a-zA-Z_0-9]*)$";
    public static final String DEFAULT_ACTIONNAMETEMPLATE = "_${method}";
    private TextTemplateEvaluator evaluator_ = new SimpleTextTemplateEvaluator();
    private Pattern pattern_;
    private String template_;
    private String pageComponentNameTemplate_;
    private String actionNameTemplate_;
    private String pathInfoTemplate_;
    private String parameterTemplate_;
    private String defaultReturnValueTemplate_;
    private Pattern buttonNamePatternForDispatching_ = Pattern.compile("_([a-zA-Z_][a-zA-Z_0-9]*)$");
    private boolean denied_;
    private boolean ignored_;
    private Pattern pageComponentNameTemplatePattern_;
    private Pattern pageComponentNamePattern_;
    private ActionManager actionManager_;
    private final Log log_ = LogFactory.getLog(YmirPathMapping.class);

    public YmirPathMapping(String patternString, String pageComponentNameTemplate) {
        this(false, patternString, pageComponentNameTemplate, DEFAULT_ACTIONNAMETEMPLATE, null, null, null);
    }

    public YmirPathMapping(boolean denied, String patternString, String pageComponentNameTemplate) {
        this(denied, patternString, pageComponentNameTemplate, DEFAULT_ACTIONNAMETEMPLATE, null, null, null);
    }

    public YmirPathMapping(String patternString, String pageComponentNameTemplate, String pathInfoTemplate) {
        this(false, patternString, pageComponentNameTemplate, DEFAULT_ACTIONNAMETEMPLATE, pathInfoTemplate, null, null);
    }

    public YmirPathMapping(boolean denied, String patternString, String pageComponentNameTemplate, String pathInfoTemplate) {
        this(denied, patternString, pageComponentNameTemplate, DEFAULT_ACTIONNAMETEMPLATE, pathInfoTemplate, null, null);
    }

    public YmirPathMapping(String patternString, String pageComponentNameTemplate, String pathInfoTemplate, String parameterTemplate) {
        this(false, patternString, pageComponentNameTemplate, DEFAULT_ACTIONNAMETEMPLATE, pathInfoTemplate, parameterTemplate, null);
    }

    public YmirPathMapping(boolean denied, String patternString, String pageComponentNameTemplate, String pathInfoTemplate, String parameterTemplate) {
        this(denied, patternString, pageComponentNameTemplate, DEFAULT_ACTIONNAMETEMPLATE, pathInfoTemplate, parameterTemplate, null);
    }

    public YmirPathMapping(String patternString, String pageComponentNameTemplate, String actionNameTemplate, String pathInfoTemplate, String parameterTemplate) {
        this(false, patternString, pageComponentNameTemplate, actionNameTemplate, pathInfoTemplate, parameterTemplate, null);
    }

    public YmirPathMapping(boolean denied, String patternString, String pageComponentNameTemplate, String actionNameTemplate, String pathInfoTemplate, String parameterTemplate) {
        this(denied, patternString, pageComponentNameTemplate, actionNameTemplate, pathInfoTemplate, parameterTemplate, null);
    }

    public YmirPathMapping(String patternString, String pageComponentNameTemplate, String actionNameTemplate, String pathInfoTemplate, String parameterTemplate, String defaultReturnValueTemplate) {
        this(false, patternString, pageComponentNameTemplate, actionNameTemplate, pathInfoTemplate, parameterTemplate, defaultReturnValueTemplate);
    }

    public YmirPathMapping(boolean denied, String patternString, String pageComponentNameTemplate, String actionNameTemplate, String pathInfoTemplate, String parameterTemplate, String defaultReturnValueTemplate) {
        this.denied_ = denied;
        this.pattern_ = Pattern.compile(patternString);
        this.setPageComponentNameTemplate(pageComponentNameTemplate);
        this.actionNameTemplate_ = actionNameTemplate;
        this.pathInfoTemplate_ = pathInfoTemplate;
        this.parameterTemplate_ = parameterTemplate;
        this.defaultReturnValueTemplate_ = defaultReturnValueTemplate;
    }

    public YmirPathMapping(boolean ignored, String patternString) {
        this.ignored_ = ignored;
        this.pattern_ = Pattern.compile(patternString);
    }

    void setPageComponentNameTemplate(String pageComponentNameTemplate) {
        this.pageComponentNameTemplate_ = pageComponentNameTemplate;
        this.pageComponentNameTemplatePattern_ = this.pageComponentNameTemplate_ != null ? Pattern.compile(this.getTemplatePattern(this.pageComponentNameTemplate_)) : null;
    }

    String getTemplatePattern(String template) {
        Matcher matcher = PATTERN_PLACEHOLDER.matcher(template);
        StringBuilder sb = new StringBuilder();
        int pre = 0;
        while (matcher.find(pre)) {
            sb.append(RegexUtils.toRegexPattern(template.substring(pre, matcher.start()))).append(PATTRENSTR_PLACEHOLDER_REGEX);
            pre = matcher.end();
        }
        sb.append(RegexUtils.toRegexPattern(template.substring(pre)));
        return sb.toString();
    }

    public YmirPathMapping(Map<String, Object> map) {
        this.denied_ = PropertyUtils.valueOf((Object)map.get(KEY_DENIED), (boolean)false);
        map.remove(KEY_DENIED);
        this.ignored_ = PropertyUtils.valueOf((Object)map.get(KEY_IGNORED), (boolean)false);
        map.remove(KEY_IGNORED);
        this.pattern_ = Pattern.compile(PropertyUtils.valueOf((Object)map.get(KEY_PATTERN), (String)null));
        map.remove(KEY_PATTERN);
        this.setPageComponentNameTemplate(PropertyUtils.valueOf((Object)map.get(KEY_PAGECOMPONENTNAME_TEMPLATE), (String)null));
        map.remove(KEY_PAGECOMPONENTNAME_TEMPLATE);
        this.actionNameTemplate_ = PropertyUtils.valueOf((Object)map.get(KEY_ACTIONNAME_TEMPLATE), (String)null);
        map.remove(KEY_ACTIONNAME_TEMPLATE);
        this.pathInfoTemplate_ = PropertyUtils.valueOf((Object)map.get(KEY_PATHINFO_TEMPLATE), (String)null);
        map.remove(KEY_PATHINFO_TEMPLATE);
        this.parameterTemplate_ = PropertyUtils.valueOf((Object)map.get(KEY_PARAMETER_TEMPLATE), (String)null);
        map.remove(KEY_PARAMETER_TEMPLATE);
        this.setReverseMapping(PropertyUtils.valueOf((Object)map.get(KEY_PAGECOMPONENTNAME_PATTERN), (String)null), PropertyUtils.valueOf((Object)map.get(KEY_TEMPLATE), (String)null));
        map.remove(KEY_PAGECOMPONENTNAME_PATTERN);
        map.remove(KEY_TEMPLATE);
        if (!map.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String delim = "Unknown key exists (typo?): ";
            Iterator<String> itr = map.keySet().iterator();
            while (itr.hasNext()) {
                sb.append(delim).append(itr.next());
                delim = ", ";
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public void setReverseMapping(String pageComponentNamePatternString, String template) {
        this.pageComponentNamePattern_ = pageComponentNamePatternString != null ? Pattern.compile(pageComponentNamePatternString) : null;
        this.template_ = template;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setActionManager(ActionManager actionManager) {
        this.actionManager_ = actionManager;
    }

    public String getActionNameTemplate() {
        return this.actionNameTemplate_;
    }

    public String getPageComponentNameTemplate() {
        return this.pageComponentNameTemplate_;
    }

    public String getPathInfoTemplate() {
        return this.pathInfoTemplate_;
    }

    public String getQueryStringTemplate() {
        return this.parameterTemplate_;
    }

    public Pattern getPattern() {
        return this.pattern_;
    }

    @Override
    public VariableResolver match(String path, HttpMethod method) {
        Matcher matcher = this.pattern_.matcher(path);
        if (matcher.matches()) {
            Map<String, String> map = this.createVariableResolverAsMap(path, matcher);
            map.put("METHOD", method.name());
            String lmethod = method.name().toLowerCase();
            map.put("method", lmethod);
            map.put("Method", this.upper(lmethod));
            return new MapVariableResolver(map);
        }
        return null;
    }

    Map<String, String> createVariableResolverAsMap(String pattern, Matcher matcher) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = matcher.groupCount();
        for (int j = 0; j <= count; ++j) {
            String matched = matcher.group(j);
            map.put(String.valueOf(j), matched);
            map.put(j + "u", this.upper(matched));
            map.put(j + "l", this.lower(matched));
            map.put(j + "d", this.decapitalize(matched));
        }
        return map;
    }

    String upper(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    String lower(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    String decapitalize(String str) {
        return Introspector.decapitalize(str);
    }

    @Override
    public String getPageComponentName(VariableResolver resolver) {
        return this.evaluate(this.pageComponentNameTemplate_, resolver);
    }

    public String getActionName(VariableResolver resolver) {
        return this.evaluate(this.actionNameTemplate_, resolver);
    }

    @Override
    public String getPathInfo(VariableResolver resolver) {
        return this.evaluate(this.pathInfoTemplate_, resolver);
    }

    @Override
    public Map<String, String[]> getParameterMap(VariableResolver resolver) {
        if (this.parameterTemplate_ == null) {
            return null;
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        StringTokenizer st = new StringTokenizer(this.parameterTemplate_, ";");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String tkn = st.nextToken();
            int equal = tkn.indexOf("=");
            if (equal >= 0) {
                name = tkn.substring(0, equal);
                value = this.evaluate(tkn.substring(equal + 1), resolver);
            } else {
                name = tkn;
                value = "";
            }
            Object[] current = (String[])map.get(name);
            if (current == null) {
                map.put(name, new String[]{value});
                continue;
            }
            map.put(name, (String[])ArrayUtil.add((Object[])current, (Object)value));
        }
        return map;
    }

    @Override
    public Object getDefaultReturnValue(VariableResolver resolver) {
        return this.evaluate(this.defaultReturnValueTemplate_, resolver);
    }

    @Override
    public String evaluate(String template, VariableResolver resolver) {
        if (resolver == null || template == null) {
            return null;
        }
        try {
            return this.evaluator_.evaluateAsString(template, resolver);
        }
        catch (EvaluationException ex) {
            throw new RuntimeException("Can't evaluate template: " + template + ", resolver=" + resolver, ex);
        }
    }

    @Override
    public boolean isDenied() {
        return this.denied_;
    }

    @Override
    public boolean isIgnored() {
        return this.ignored_;
    }

    protected String extractButtonName(String name) {
        Matcher matcher;
        if (this.buttonNamePatternForDispatching_ != null && (matcher = this.buttonNamePatternForDispatching_.matcher(name)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public Action getAction(PageComponent pageComponent, final Request request, VariableResolver resolver) {
        final String actionName = this.getActionName(resolver);
        final String defaultActionName = this.getDefaultActionName();
        Action action = (Action)pageComponent.accept(new PageComponentVisitor<Action>(){

            @Override
            public Action process(PageComponent pageComponent, Object ... parameters) {
                return YmirPathMapping.this.getActionForButton(pageComponent.getPage(), pageComponent.getPageClass(), actionName, request);
            }
        }, new Object[0]);
        if (action == null) {
            action = (Action)pageComponent.accept(new PageComponentVisitor<Action>(){

                @Override
                public Action process(PageComponent pageComponent, Object ... parameters) {
                    return YmirPathMapping.this.getActionForButton(pageComponent.getPage(), pageComponent.getPageClass(), defaultActionName, request);
                }
            }, new Object[0]);
        }
        if (action == null) {
            action = (Action)pageComponent.accept(new PageComponentVisitor<Action>(){

                @Override
                public Action process(PageComponent pageComponent, Object ... parameters) {
                    return YmirPathMapping.this.getAction(pageComponent.getPage(), pageComponent.getPageClass(), actionName, request);
                }
            }, new Object[0]);
        }
        if (action == null) {
            action = (Action)pageComponent.accept(new PageComponentVisitor<Action>(){

                @Override
                public Action process(PageComponent pageComponent, Object ... parameters) {
                    return YmirPathMapping.this.getAction(pageComponent.getPage(), pageComponent.getPageClass(), defaultActionName, request);
                }
            }, new Object[0]);
        }
        return action;
    }

    protected Action getActionForButton(Object page, Class<?> pageClass, String actionName, Request request) {
        Method[] methods = ClassUtils.getMethods(pageClass);
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("getActionForButton: search " + pageClass + " for " + actionName + " method..."));
        }
        for (int i = 0; i < methods.length; ++i) {
            Action action = this.createActionForButton(page, pageClass, methods[i], actionName, request);
            if (action == null) continue;
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("getActionForButton: Found: " + methods[i]));
            }
            return action;
        }
        return null;
    }

    protected Action createActionForButton(Object page, Class<?> pageClass, Method method, String actionName, Request request) {
        String name = method.getName();
        if (!name.startsWith(actionName)) {
            return null;
        }
        String buttonName = this.extractButtonName(name.substring(actionName.length()));
        if (buttonName == null) {
            return null;
        }
        return this.createActionWithParameters(page, pageClass, method, buttonName, request);
    }

    Action createActionWithParameters(Object page, Class<?> pageClass, Method method, String buttonName, Request request) {
        Iterator<String> itr = request.getParameterNames();
        while (itr.hasNext()) {
            Button button;
            String pname = itr.next();
            if (!pname.startsWith(buttonName) || !(button = new Button(pname)).isValid() || !buttonName.equals(button.getName())) continue;
            return this.actionManager_.newAction(page, pageClass, method, button.getParameters());
        }
        return null;
    }

    protected Action getAction(Object page, Class<?> pageClass, String actionName, Request request) {
        Method[] methods = ClassUtils.getMethods(pageClass, actionName);
        if (methods.length == 1) {
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("getAction: Found: " + methods[0]));
            }
            return this.actionManager_.newAction(page, pageClass, methods[0], new Object[0]);
        }
        if (methods.length == 0) {
            return null;
        }
        throw new IllegalClientCodeRuntimeException("Action method must be single: class=" + pageClass + ", method=" + Arrays.asList(methods));
    }

    boolean mapsToPageComponentName(String pageComponentName) {
        if (pageComponentName == null) {
            return false;
        }
        return this.pageComponentNameTemplatePattern_.matcher(pageComponentName).matches();
    }

    @Override
    public Action getPrerenderAction(PageComponent pageComponent, Request request, VariableResolver resolver) {
        Method[] methods = ClassUtils.getMethods(pageComponent.getPageClass(), ACTION_PRERENDER);
        if (methods.length == 1) {
            return this.actionManager_.newAction(pageComponent.getPage(), pageComponent.getPageClass(), methods[0], new Object[0]);
        }
        if (methods.length == 0) {
            return null;
        }
        throw new IllegalClientCodeRuntimeException("Prerender method must be single: class=" + pageComponent.getPageClass() + ", method=" + Arrays.asList(methods));
    }

    protected String getDefaultActionName() {
        return ACTION_DEFAULT;
    }

    @Override
    public VariableResolver matchPageComponentName(String pageComponentName) {
        if (this.pageComponentNamePattern_ == null || this.template_ == null) {
            return null;
        }
        Matcher matcher = this.pageComponentNamePattern_.matcher(pageComponentName);
        if (matcher.matches()) {
            return new MapVariableResolver(this.createVariableResolverAsMap(pageComponentName, matcher));
        }
        return null;
    }

    @Override
    public String getPath(VariableResolver resolver) {
        if (this.pageComponentNamePattern_ == null || this.template_ == null) {
            return null;
        }
        return this.evaluate(this.template_, resolver);
    }

    @Override
    public String getActionKeyFromParameterName(String parameterName) {
        if (parameterName == null) {
            return null;
        }
        Button button = new Button(parameterName);
        if (!button.isValid()) {
            return null;
        }
        return button.getName();
    }

    public static class Button {
        private static final Pattern PATTERN = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9]*)((\\[[^]]*\\])*)");
        private static final char PARAM_PREFIX_CHAR = '[';
        private static final char PARAM_SUFFIX_CHAR = ']';
        private static final String PARAM_PREFIX = String.valueOf('[');
        private static final String PARAM_SUFFIX = String.valueOf(']');
        private String rawName_;
        private String name_;
        private String[] parameters_;
        private boolean valid_;

        public Button(String rawName) {
            this.rawName_ = rawName;
            String name = rawName.endsWith(".x") || rawName.endsWith(".y") ? rawName.substring(0, rawName.length() - 2) : rawName;
            Matcher matcher = PATTERN.matcher(name);
            if (!matcher.matches()) {
                return;
            }
            this.name_ = matcher.group(1);
            this.parameters_ = this.parseParameters(matcher.group(2));
            this.valid_ = true;
        }

        String[] parseParameters(String parametersString) {
            ArrayList<String> list = new ArrayList<String>();
            if (parametersString.length() > 0) {
                StringTokenizer st = new StringTokenizer(parametersString.substring(1, parametersString.length() - 1), PARAM_SUFFIX + PARAM_PREFIX);
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken());
                }
            }
            return list.toArray(new String[0]);
        }

        public boolean isValid() {
            return this.valid_;
        }

        public String getRawName() {
            return this.rawName_;
        }

        public String getName() {
            return this.name_;
        }

        public String[] getParameters() {
            return this.parameters_;
        }
    }
}

