/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.converter.impl;

import java.lang.annotation.Annotation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.ymir.converter.TypeConversionException;
import org.seasar.ymir.converter.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeConverterBase<T>
implements TypeConverter<T> {
    protected Class<T> type_;
    protected T defaultValue_;
    protected final Log log_ = LogFactory.getLog(this.getClass());

    @Override
    public Class<T> getType() {
        return this.type_;
    }

    public void setType(Class<T> type) {
        this.type_ = type;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue_ = defaultValue;
    }

    @Override
    public T convert(Object value, Annotation[] hint) {
        try {
            return this.tryToConvert(value, hint);
        }
        catch (TypeConversionException ex) {
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Conversion error occured. You may add a constraint annotation to the corresponding property in order to notify validation error to a user: " + value), (Throwable)ex);
            }
            return this.defaultValue_;
        }
    }

    @Override
    public T tryToConvert(Object value, Annotation[] hint) throws TypeConversionException {
        if (value == null) {
            return this.defaultValue_;
        }
        if (this.getType().isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (value.toString().length() == 0) {
            return this.defaultValue_;
        }
        return this.doConvert(value, hint);
    }

    protected abstract T doConvert(Object var1, Annotation[] var2) throws TypeConversionException;

    @Override
    public String convertToString(T value, Annotation[] hint) {
        return value.toString();
    }
}

