/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.converter.impl;

import java.lang.annotation.Annotation;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.ymir.converter.TypeConversionException;
import org.seasar.ymir.converter.impl.DateConverterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTimeConverter
extends DateConverterBase<Time> {
    public static final String PATTERN = "HH:mm:ss";

    public SqlTimeConverter() {
        this.type_ = Time.class;
        this.pattern_ = PATTERN;
    }

    @Override
    protected Time doConvert(Object value, Annotation[] hint) throws TypeConversionException {
        if (value instanceof Number) {
            return new Time(((Number)value).longValue());
        }
        if (value instanceof Date) {
            return new Time(((Date)value).getTime());
        }
        try {
            return new Time(new SimpleDateFormat(this.getPattern(hint)).parse(value.toString()).getTime());
        }
        catch (Exception ex) {
            throw new TypeConversionException(ex, value, this.getType());
        }
    }
}

