/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.constraint.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.MethodInvoker;
import org.seasar.ymir.Request;
import org.seasar.ymir.WrappingRuntimeException;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.cache.CacheManager;
import org.seasar.ymir.constraint.ConfirmationDecider;
import org.seasar.ymir.constraint.Constraint;
import org.seasar.ymir.constraint.ConstraintBag;
import org.seasar.ymir.constraint.ConstraintManager;
import org.seasar.ymir.constraint.ConstraintType;
import org.seasar.ymir.constraint.ConstraintViolatedException;
import org.seasar.ymir.constraint.CrosscuttingConstraint;
import org.seasar.ymir.constraint.PermissionDeniedException;
import org.seasar.ymir.constraint.ValidationFailedException;
import org.seasar.ymir.constraint.annotation.ConstraintAnnotation;
import org.seasar.ymir.constraint.annotation.ConstraintHolder;
import org.seasar.ymir.constraint.annotation.Validator;
import org.seasar.ymir.constraint.impl.CrosscuttingConstraintAdapter;
import org.seasar.ymir.constraint.impl.MethodConfirmationDecider;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintManagerImpl
implements ConstraintManager {
    private static final ConfirmationDecider DECIDER_ALWAYS = new ConfirmationDecider(){

        @Override
        public boolean isConfirmed(Object page, Request request, ConstraintType type, Set<ConstraintType> suppressTypeSet) {
            return true;
        }
    };
    private static final ConfirmationDecider DECIDER_DEPENDS_ON_SUPPRESSTYPE = new ConfirmationDecider(){

        @Override
        public boolean isConfirmed(Object page, Request request, ConstraintType type, Set<ConstraintType> suppressTypeSet) {
            return !suppressTypeSet.contains((Object)type);
        }
    };
    private ActionManager actionManager_;
    private AnnotationHandler annotationHandler_;
    private ApplicationManager applicationManager_;
    private Map<AnnotatedElement, ConstraintBag<?>[]> bagsWithAlwaysDeciderMap_;
    private Map<AnnotatedElement, ConstraintBag<?>[]> bagsWithDependsOnSuppressTypeDeciderMap_;
    private Map<Key, Method[]> validatorMethodsMap_;

    @Binding(bindingType=BindingType.MUST)
    public void setActionManager(ActionManager actionManager) {
        this.actionManager_ = actionManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setCacheManager(CacheManager cacheManager) {
        this.bagsWithAlwaysDeciderMap_ = cacheManager.newMap();
        this.bagsWithDependsOnSuppressTypeDeciderMap_ = cacheManager.newMap();
        this.validatorMethodsMap_ = cacheManager.newMap();
    }

    @Override
    public ConfirmationDecider getAlwaysDecider() {
        return DECIDER_ALWAYS;
    }

    @Override
    public ConfirmationDecider getDependsOnSuppressTypeDecider() {
        return DECIDER_DEPENDS_ON_SUPPRESSTYPE;
    }

    @Override
    public void confirmConstraint(ConstraintBag<?>[] bags, Set<ConstraintType> suppressTypeSet, Object bean, Request request, Notes notes) throws PermissionDeniedException {
        for (int i = 0; i < bags.length; ++i) {
            try {
                bags[i].confirm(bean, request, suppressTypeSet);
                continue;
            }
            catch (PermissionDeniedException ex) {
                throw ex;
            }
            catch (ValidationFailedException ex) {
                notes.add(ex.getNotes());
                continue;
            }
            catch (ConstraintViolatedException ex) {
                throw new RuntimeException("Constraint can throw sub-class of either PermissionDeniedException or ValidationFailedException", ex);
            }
        }
    }

    @Override
    public void confirmConstraint(Class<?> beanClass, Set<ConstraintType> suppressTypeSet, Object bean, Request request, Notes notes) throws PermissionDeniedException {
        this.confirmConstraint(this.getConstraintBagsForClass(beanClass, DECIDER_DEPENDS_ON_SUPPRESSTYPE), suppressTypeSet, bean, request, notes);
        if (!suppressTypeSet.contains((Object)ConstraintType.VALIDATION)) {
            Action[] validators = this.getValidators(bean, beanClass, request.getCurrentDispatch().getAction());
            for (int i = 0; i < validators.length; ++i) {
                try {
                    Object invoked = validators[i].invoke();
                    if (!(invoked instanceof Notes)) continue;
                    notes.add((Notes)invoked);
                    continue;
                }
                catch (WrappingRuntimeException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof ValidationFailedException) {
                        notes.add(((ValidationFailedException)cause).getNotes());
                        continue;
                    }
                    throw ex;
                }
            }
        }
    }

    @Override
    public void confirmConstraint(Object component, Request request, Annotation annotation, AnnotatedElement element) throws ConstraintViolatedException {
        for (Annotation expanded : this.annotationHandler_.getMarkedAnnotations(ConstraintAnnotation.class, annotation)) {
            Class<? extends Constraint<?>> constraintClass = expanded.annotationType().getAnnotation(ConstraintAnnotation.class).component();
            Constraint constraint = (Constraint)this.getS2Container().getComponent(constraintClass);
            constraint.confirm(component, request, expanded, element);
        }
    }

    @Override
    public ConstraintBag<?>[] getConstraintBagsForClass(Class<?> beanClass, ConfirmationDecider decider) {
        if (beanClass == null) {
            return CONSTRAINTBAGS_EMPTY;
        }
        Map<AnnotatedElement, ConstraintBag<?>[]> bagsMap = null;
        ConstraintBag<?>[] bags = null;
        if (decider == DECIDER_ALWAYS) {
            bagsMap = this.bagsWithAlwaysDeciderMap_;
        } else if (decider == DECIDER_DEPENDS_ON_SUPPRESSTYPE) {
            bagsMap = this.bagsWithDependsOnSuppressTypeDeciderMap_;
        }
        if (bagsMap != null) {
            bags = bagsMap.get(beanClass);
        }
        if (bags == null) {
            ArrayList list = new ArrayList();
            this.createConstraintBagsForClass(beanClass, decider, list);
            bags = list.toArray(CONSTRAINTBAGS_EMPTY);
        }
        if (bagsMap != null) {
            bagsMap.put(beanClass, bags);
        }
        return bags;
    }

    @Override
    public ConstraintBag<?>[] getConstraintBags(AnnotatedElement element, ConfirmationDecider decider) {
        if (element == null) {
            return CONSTRAINTBAGS_EMPTY;
        }
        Map<AnnotatedElement, ConstraintBag<?>[]> bagsMap = null;
        ConstraintBag<?>[] bags = null;
        if (decider == DECIDER_ALWAYS) {
            bagsMap = this.bagsWithAlwaysDeciderMap_;
        } else if (decider == DECIDER_DEPENDS_ON_SUPPRESSTYPE) {
            bagsMap = this.bagsWithDependsOnSuppressTypeDeciderMap_;
        }
        if (bagsMap != null) {
            bags = bagsMap.get(element);
        }
        if (bags == null) {
            ArrayList list = new ArrayList();
            this.createConstraintBags(element, decider, list);
            bags = list.toArray(CONSTRAINTBAGS_EMPTY);
        }
        if (bagsMap != null) {
            bagsMap.put(element, bags);
        }
        return bags;
    }

    @Override
    public void getConstraintBags(AnnotatedElement element, ConfirmationDecider decider, List<ConstraintBag<?>> list) {
        if (element == null) {
            return;
        }
        Map<AnnotatedElement, ConstraintBag<?>[]> bagsMap = null;
        if (decider == DECIDER_ALWAYS) {
            bagsMap = this.bagsWithAlwaysDeciderMap_;
        } else if (decider == DECIDER_DEPENDS_ON_SUPPRESSTYPE) {
            bagsMap = this.bagsWithDependsOnSuppressTypeDeciderMap_;
        }
        if (bagsMap != null) {
            ConstraintBag<?>[] bags = bagsMap.get(element);
            if (bags == null) {
                ArrayList l = new ArrayList();
                this.createConstraintBags(element, decider, l);
                bags = l.toArray(CONSTRAINTBAGS_EMPTY);
                bagsMap.put(element, bags);
            }
            list.addAll(Arrays.asList(bags));
        } else {
            this.createConstraintBags(element, decider, list);
        }
    }

    @Override
    public void getConstraintBags(AnnotatedElement element, CrosscuttingConstraint crosscuttingConstraint, List<ConstraintBag<?>> list) {
        list.add(new ConstraintBag<Annotation>(new CrosscuttingConstraintAdapter(crosscuttingConstraint), crosscuttingConstraint.getConstraintType(), crosscuttingConstraint));
    }

    protected Action[] getValidators(Object bean, Class<?> beanClass, Action action) {
        ArrayList<Object> list;
        Key key;
        Method[] validatorMethods;
        MethodInvoker actionInvoker;
        String actionName = null;
        Object[] actionParameters = new Object[]{};
        if (action != null && (actionInvoker = action.getMethodInvoker()) != null) {
            Method actionMethod = actionInvoker.getMethod();
            if (actionMethod != null) {
                actionName = actionMethod.getName();
            }
            actionParameters = actionInvoker.getParameters();
        }
        if ((validatorMethods = this.validatorMethodsMap_.get(key = new Key(beanClass, actionName))) == null) {
            list = new ArrayList<Object>();
            for (Method method : ClassUtils.getMethods(beanClass)) {
                if (!this.actionManager_.isMatched(actionName, this.getValidatorValue(method))) continue;
                list.add(method);
            }
            validatorMethods = list.toArray(new Method[0]);
            this.validatorMethodsMap_.put(key, validatorMethods);
        }
        list = new ArrayList();
        for (int i = 0; i < validatorMethods.length; ++i) {
            list.add(this.actionManager_.newAction(bean, beanClass, validatorMethods[i], actionParameters));
        }
        return list.toArray(new Action[0]);
    }

    private String[] getValidatorValue(Method method) {
        Validator validator = this.annotationHandler_.getAnnotation(method, Validator.class);
        if (validator != null) {
            return validator.value();
        }
        return null;
    }

    protected S2Container getS2Container() {
        return this.applicationManager_.findContextApplication().getS2Container();
    }

    private void createConstraintBagsForClass(Class<?> beanClass, ConfirmationDecider decider, List<ConstraintBag<?>> bags) {
        this.createConstraintBags(beanClass, decider, bags);
        this.createFromClassMembers(beanClass, decider, bags);
        this.createFromConstraintHolders(beanClass, decider, bags);
    }

    protected void createFromClassMembers(Class<?> beanClass, ConfirmationDecider decider, List<ConstraintBag<?>> bags) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex);
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            this.createConstraintBags(pds[i].getReadMethod(), decider, bags);
            this.createConstraintBags(pds[i].getWriteMethod(), decider, bags);
        }
    }

    protected void createFromConstraintHolders(Class<?> beanClass, ConfirmationDecider decider, List<ConstraintBag<?>> bags) {
        for (Method method : ClassUtils.getMethods(beanClass)) {
            if (this.annotationHandler_.getAnnotation(method, ConstraintHolder.class) == null) continue;
            this.createConstraintBags(method, new MethodConfirmationDecider(this.actionManager_, beanClass, method, decider), bags, false);
        }
    }

    protected void createConstraintBags(AnnotatedElement element, ConfirmationDecider decider, List<ConstraintBag<?>> bags) {
        this.createConstraintBags(element, decider, bags, true);
    }

    protected void createConstraintBags(AnnotatedElement element, ConfirmationDecider decider, List<ConstraintBag<?>> bags, boolean exceptForConstraintHolder) {
        if (element == null) {
            return;
        }
        if (exceptForConstraintHolder && this.annotationHandler_.isAnnotationPresent(element, ConstraintHolder.class)) {
            return;
        }
        for (Annotation annotation : this.annotationHandler_.getMarkedAnnotations(element, ConstraintAnnotation.class)) {
            ConstraintAnnotation constraintAnnotation = annotation.annotationType().getAnnotation(ConstraintAnnotation.class);
            bags.add(new ConstraintBag<Annotation>((Constraint)this.getS2Container().getComponent(constraintAnnotation.component()), annotation, element, decider));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Key {
        private Class<?> pageClass_;
        private String actionName_;

        public Key(Class<?> pageClass, String actionName) {
            this.pageClass_ = pageClass;
            this.actionName_ = actionName;
        }

        public int hashCode() {
            int code = this.pageClass_.hashCode();
            if (this.actionName_ != null) {
                code += this.actionName_.hashCode();
            }
            return code;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Key o = (Key)obj;
            if (o.actionName_ == null ? this.actionName_ != null : !o.actionName_.equals(this.actionName_)) {
                return false;
            }
            return o.pageClass_ == this.pageClass_;
        }
    }
}

