/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.constraint.impl;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.seasar.ymir.Request;
import org.seasar.ymir.constraint.Constraint;
import org.seasar.ymir.constraint.ConstraintUtils;
import org.seasar.ymir.util.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConstraint<T extends Annotation>
implements Constraint<T> {
    private static final String SUFFIX_CONSTRAINT = "Constraint";

    protected String getConstraintKey() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith(SUFFIX_CONSTRAINT)) {
            name = name.substring(0, name.length() - SUFFIX_CONSTRAINT.length());
        }
        return Introspector.decapitalize(name);
    }

    protected String getFullMessageKey(String messageKey) {
        return ConstraintUtils.getFullMessageKey(this.getConstraintKey(), messageKey);
    }

    protected String getPropertyName(AnnotatedElement element) {
        if (!(element instanceof Method)) {
            return null;
        }
        return BeanUtils.toPropertyName(((Method)element).getName());
    }

    protected Class<?> getPropertyType(AnnotatedElement element) {
        if (!(element instanceof Method)) {
            return null;
        }
        return BeanUtils.getPropertyType((Method)element);
    }

    protected String[] getParameterNames(Request request, String string, String[] strings) {
        return this.expand(this.add(string, strings), request);
    }

    String[] expand(String[] names, Request request) {
        LinkedHashSet<String> expandedNameSet = new LinkedHashSet<String>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].startsWith("#")) {
                Pattern pattern = Pattern.compile(names[i].substring("#".length()));
                Iterator<String> itr = request.getParameterNames();
                while (itr.hasNext()) {
                    String name = itr.next();
                    if (!pattern.matcher(name).matches()) continue;
                    expandedNameSet.add(name);
                }
                continue;
            }
            expandedNameSet.add(names[i]);
        }
        return expandedNameSet.toArray(new String[0]);
    }

    protected String[] add(String string, String[] strings) {
        if (string != null) {
            String[] newStrings = new String[strings.length + 1];
            newStrings[0] = string;
            System.arraycopy(strings, 0, newStrings, 1, strings.length);
            return newStrings;
        }
        return strings;
    }

    protected String[] getParameterNames(Request request, String string, String[] strings, String[] strings2) {
        return this.expand(this.add(string, strings, strings2), request);
    }

    protected String[] add(String string, String[] strings, String[] strings2) {
        String[] newStrings = new String[strings.length + strings2.length + (string != null ? 1 : 0)];
        int offset = 0;
        if (string != null) {
            newStrings[offset++] = string;
        }
        System.arraycopy(strings, 0, newStrings, offset, strings.length);
        System.arraycopy(strings2, 0, newStrings, offset + strings.length, strings2.length);
        return newStrings;
    }
}

