/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.constraint;

import org.seasar.ymir.FormFile;
import org.seasar.ymir.Request;

public class ConstraintUtils {
    private ConstraintUtils() {
    }

    public static String getFullMessageKey(String constraintKey, String messageKey) {
        String fullMessageKey = messageKey == null || messageKey.length() == 0 ? "error.constraint." + constraintKey : (messageKey.startsWith("!") ? messageKey.substring("!".length()) : "error.constraint." + constraintKey + "." + messageKey);
        return fullMessageKey;
    }

    public static String getFullMessageKey(String constraintKey) {
        return "error.constraint." + constraintKey;
    }

    public static boolean isEmpty(Request request, String name, boolean completely, boolean allowWhitespace, boolean allowFullWidthWhitespace) {
        block9: {
            FormFile[] files;
            String[] values = request.getParameterValues(name);
            if (values != null) {
                int i;
                if (completely) {
                    for (i = 0; i < values.length; ++i) {
                        if (!ConstraintUtils.isEmpty(values[i], allowWhitespace, allowFullWidthWhitespace)) continue;
                        return true;
                    }
                } else {
                    for (i = 0; i < values.length; ++i) {
                        if (ConstraintUtils.isEmpty(values[i], allowWhitespace, allowFullWidthWhitespace)) continue;
                        return false;
                    }
                }
            }
            if ((files = request.getFileParameterValues(name)) == null) break block9;
            if (completely) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].getSize() != 0L) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].getSize() <= 0L) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isEmpty(String value, boolean allowWhitespace, boolean allowFullWidthWhitespace) {
        if (value == null) {
            return true;
        }
        if (!allowWhitespace) {
            value = value.trim();
        }
        if (!allowFullWidthWhitespace) {
            value = value.replace("\u3000", "");
        }
        return value.length() == 0;
    }
}

