/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.aop.interceptor.impl;

import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.Response;
import org.seasar.ymir.response.RedirectResponse;
import org.seasar.ymir.util.ServletUtils;

public abstract class AbstractSchemeConstraintInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private ApplicationManager applicationManager_;

    @Binding(bindingType=BindingType.MUST)
    public final void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        String scheme = this.getScheme();
        int port = this.getPort(invocation);
        if (scheme.equals(httpRequest.getScheme())) {
            return invocation.proceed();
        }
        String url = ServletUtils.constructRequestURL(httpRequest, scheme, port);
        Class<Response> returnType = invocation.getMethod().getReturnType();
        if (returnType == String.class) {
            return "redirect:" + url;
        }
        if (returnType.isAssignableFrom(Response.class)) {
            return new RedirectResponse(url);
        }
        throw new IllegalClientCodeRuntimeException("The return type must be String or supertype of Response: " + invocation.getMethod());
    }

    protected abstract String getScheme();

    protected abstract int getPort(MethodInvocation var1);

    HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.applicationManager_.findContextApplication().getS2Container().getComponent(HttpServletRequest.class);
    }
}

