/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.ymir.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String trunk_;
    private Map<String, String[]> parameterMap_;
    private String parameterEncoding_;
    private String pathParameter_;
    private String fragment_ = "";
    private boolean asNoCache_;

    public Path() {
        this(null);
    }

    public Path(String path) {
        this(path, new LinkedHashMap<String, String[]>());
    }

    public Path(String path, String parameterEncoding) {
        this(path, new LinkedHashMap<String, String[]>(), parameterEncoding);
    }

    public Path(String path, Map<String, String[]> parameterMap) {
        this(path, parameterMap, "UTF-8");
    }

    public Path(String path, Map<String, String[]> parameterMap, String parameterEncoding) {
        this.parameterMap_ = parameterMap;
        this.parameterEncoding_ = parameterEncoding;
        this.analyze(path);
    }

    void analyze(String path) {
        int semi;
        int question;
        if (path == null) {
            return;
        }
        int sharp = path.lastIndexOf(35);
        if (sharp >= 0) {
            this.fragment_ = path.substring(sharp);
            path = path.substring(0, sharp);
        }
        if ((question = path.indexOf(63)) >= 0) {
            int idx;
            int pre = question + 1;
            while ((idx = path.indexOf(38, pre)) >= 0) {
                this.addEncodedParameter(path.substring(pre, idx));
                pre = idx + 1;
            }
            if (pre < path.length()) {
                this.addEncodedParameter(path.substring(pre));
            }
            path = path.substring(0, question);
        }
        if ((semi = path.indexOf(59)) >= 0) {
            this.pathParameter_ = path.substring(semi + 1);
            path = path.substring(0, semi);
        }
        this.trunk_ = path;
    }

    void addEncodedParameter(String encodedParam) {
        String encodedValue;
        String encodedName;
        int equal = encodedParam.indexOf(61);
        if (equal >= 0) {
            encodedName = encodedParam.substring(0, equal);
            encodedValue = encodedParam.substring(equal + 1);
        } else {
            encodedName = encodedParam;
            encodedValue = "";
        }
        try {
            this.addParameter(URLDecoder.decode(encodedName, this.parameterEncoding_), URLDecoder.decode(encodedValue, this.parameterEncoding_));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        String queryString;
        StringBuilder sb = new StringBuilder();
        sb.append(this.trunk_);
        if (this.pathParameter_ != null) {
            sb.append(";").append(this.pathParameter_);
        }
        if ((queryString = this.getQueryString()) != null) {
            sb.append("?").append(queryString);
        }
        sb.append(this.fragment_);
        return sb.toString();
    }

    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        if (this.parameterMap_ != null) {
            for (Map.Entry<String, String[]> entry : this.parameterMap_.entrySet()) {
                String encodedKey;
                String key = entry.getKey();
                String[] values = entry.getValue();
                if (key == null || values == null || values.length == 0) continue;
                try {
                    encodedKey = URLEncoder.encode(key, this.parameterEncoding_);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
                for (int i = 0; i < values.length; ++i) {
                    sb.append(delim).append(encodedKey).append("=");
                    try {
                        sb.append(URLEncoder.encode(values[i], this.parameterEncoding_));
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException(ex);
                    }
                    delim = "&";
                }
            }
        }
        if (this.asNoCache_) {
            sb.append(delim).append(this.getUniqueKey());
            delim = "&";
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    String getUniqueKey() {
        return StringUtils.generateLocalKey(this);
    }

    public String getTrunk() {
        return this.trunk_;
    }

    public Path setTrunk(String trunk) {
        this.trunk_ = trunk;
        return this;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap_;
    }

    public Path setParameterMap(Map<String, String[]> parameterMap) {
        this.parameterMap_ = parameterMap;
        return this;
    }

    public Path setParameter(String name, String value) {
        return this.setParameter(name, new String[]{value});
    }

    public Path setParameter(String name, String[] values) {
        this.parameterMap_.put(name, values);
        return this;
    }

    public Path addParameter(String name, String value) {
        String[] newValues;
        if (value == null) {
            return this;
        }
        String[] values = this.parameterMap_.get(name);
        if (values == null) {
            newValues = new String[]{value};
        } else {
            newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value;
        }
        this.parameterMap_.put(name, newValues);
        return this;
    }

    public Path removeParameter(String name) {
        this.parameterMap_.remove(name);
        return this;
    }

    public Path clearParameters() {
        this.parameterMap_.clear();
        return this;
    }

    public String getParameterEncoding() {
        return this.parameterEncoding_;
    }

    public Path setParameterEncoding(String parameterEncoding) {
        this.parameterEncoding_ = parameterEncoding;
        return this;
    }

    public boolean isAsNoCache() {
        return this.asNoCache_;
    }

    public Path setAsNoCache(boolean asNoCache) {
        this.asNoCache_ = asNoCache;
        return this;
    }

    public String getPathParameter() {
        return this.pathParameter_;
    }

    public String getFragment() {
        return this.fragment_;
    }
}

