/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.kvasir.util.collection.MapProperties;
import org.seasar.kvasir.util.io.IOUtils;

public class PersistentProperties {
    private static final Log log_ = LogFactory.getLog(PersistentProperties.class);
    private File file_;
    private MapProperties prop_ = new MapProperties(new TreeMap());

    public PersistentProperties(File file) {
        this.file_ = file;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        if (this.file_.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.file_);
                this.prop_.load((InputStream)new BufferedInputStream(fis));
            }
            catch (IOException ex) {
                try {
                    log_.error((Object)("Can't read properties: " + this.file_));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    public MapProperties getProperties() {
        return this.prop_;
    }

    public void setProperty(String name, String value) {
        this.prop_.setProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.file_.exists()) {
            this.file_.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file_);
            this.prop_.store((OutputStream)new BufferedOutputStream(fos), "ISO-8859-1");
            fos = null;
        }
        catch (IOException ex) {
            try {
                log_.error((Object)("Can't write properties: " + this.file_));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }
}

