/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.conversation.impl;

import java.io.ObjectStreamException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.conversation.Conversation;
import org.seasar.ymir.hotdeploy.HotdeployManager;
import org.seasar.ymir.util.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationImpl
implements Conversation {
    private static final long serialVersionUID = -994133844419542105L;
    private transient HotdeployManager hotdeployManager_;
    private transient ApplicationManager applicationManager_;
    private String name_;
    private Map<String, Object> attributeMap_ = new ConcurrentHashMap<String, Object>();
    private String phase_;
    private Object reenterResponse_;

    public ConversationImpl(String name) {
        this.name_ = name;
    }

    public void setHotdeployManager(HotdeployManager hotdeployManager) {
        this.hotdeployManager_ = hotdeployManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("{").append(LogUtils.LS);
        sb.append("  ").append("name=").append(this.name_);
        sb.append(", ").append("phase=").append(this.phase_);
        sb.append(", ").append("reenterResponse=").append(this.reenterResponse_).append(LogUtils.LS);
        sb.append("  ").append("attributes=").append(LogUtils.addIndent(LogUtils.toString(this.attributeMap_))).append(LogUtils.LS);
        sb.append("}");
        return sb.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        this.hotdeployManager_ = (HotdeployManager)YmirContext.getYmir().getApplication().getS2Container().getComponent(HotdeployManager.class);
        this.applicationManager_ = (ApplicationManager)YmirContext.getYmir().getApplication().getS2Container().getComponent(ApplicationManager.class);
        return this;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = this.attributeMap_.get(name);
        if (this.applicationManager_.findContextApplication().isUnderDevelopment()) {
            return this.hotdeployManager_.fit(value);
        }
        return value;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributeMap_.put(name, value);
        } else {
            this.attributeMap_.remove(name);
        }
    }

    @Override
    public String getPhase() {
        return this.phase_;
    }

    @Override
    public synchronized void setPhase(String phase) {
        this.phase_ = phase;
    }

    @Override
    public Object getReenterResponse() {
        return this.reenterResponse_;
    }

    @Override
    public void setReenterResponse(Object reenterResponse) {
        this.reenterResponse_ = reenterResponse;
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.attributeMap_.keySet().iterator();
    }
}

