/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.ActionWrapper;
import org.seasar.ymir.MethodInvoker;
import org.seasar.ymir.Response;
import org.seasar.ymir.cache.CacheManager;
import org.seasar.ymir.impl.ActionImpl;
import org.seasar.ymir.impl.MethodInvokerImpl;
import org.seasar.ymir.impl.VoidMethodInvoker;
import org.seasar.ymir.response.PassthroughResponse;
import org.seasar.ymir.response.constructor.ResponseConstructor;
import org.seasar.ymir.response.constructor.ResponseConstructorSelector;
import org.seasar.ymir.scope.ScopeManager;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManagerImpl
implements ActionManager {
    private ResponseConstructorSelector responseConstructorSelector_;
    private ScopeManager scopeManager_;
    private Map<String, Pattern> patternMap_;
    private static final Log log_ = LogFactory.getLog(ActionManagerImpl.class);

    @Binding(bindingType=BindingType.MUST)
    public void setCacheManager(CacheManager cacheManager) {
        this.patternMap_ = cacheManager.newMap();
    }

    @Binding(bindingType=BindingType.MUST)
    public void setResponseConstructorSelector(ResponseConstructorSelector responseConstructorSelector) {
        this.responseConstructorSelector_ = responseConstructorSelector;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setScopeManager(ScopeManager scopeManager) {
        this.scopeManager_ = scopeManager;
    }

    @Override
    public Action newAction(Object page, Class<?> pageClass, Method method, Object ... extendedParams) {
        return new ActionImpl(page, pageClass, this.newMethodInvoker(pageClass, method, extendedParams));
    }

    @Override
    public MethodInvoker newMethodInvoker(Class<?> pageClass, Method method, Object ... extendedParams) {
        return new MethodInvokerImpl(method, this.scopeManager_.resolveParameters(pageClass, method, extendedParams));
    }

    @Override
    public Action newAction(Object page, Class<?> pageClass, MethodInvoker methodInvoker) {
        return new ActionImpl(page, pageClass, methodInvoker);
    }

    @Override
    public Action newAction(Object page, MethodInvoker methodInvoker) {
        return new ActionImpl(page, page.getClass(), methodInvoker);
    }

    @Override
    public Action newVoidAction(Object page) {
        return this.newAction(page, (MethodInvoker)VoidMethodInvoker.INSTANCE);
    }

    @Override
    public Action newAction(Action action, final MethodInvoker methodInvoker) {
        return new ActionWrapper(action){

            public MethodInvoker getMethodInvoker() {
                return methodInvoker;
            }
        };
    }

    @Override
    public Response invokeAction(Action action) {
        Response response = new PassthroughResponse();
        if (action != null && action.shouldInvoke()) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("INVOKE: " + ClassUtils.getPrettyName(action.getTarget()) + "#" + action.getMethodInvoker()));
            }
            response = this.constructResponse(action.getTarget(), action.getReturnType(), action.invoke());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response constructResponse(Object page, Class<?> returnType, Object returnValue) {
        ResponseConstructor<?> constructor = this.responseConstructorSelector_.getResponseConstructor(returnType);
        if (constructor == null) {
            throw new ComponentNotFoundRuntimeException((Object)("Can't find ResponseConstructor for type '" + returnType + "' in ResponseConstructorSelector"));
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (page != null) {
                Thread.currentThread().setContextClassLoader(page.getClass().getClassLoader());
            }
            Response response = constructor.constructResponse(page, returnValue);
            return response;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    @Override
    public boolean isMatched(String actionName, String[] actionNamePatterns) {
        if (actionNamePatterns == null) {
            return false;
        }
        if (actionNamePatterns.length == 0) {
            return true;
        }
        if (actionName == null) {
            return false;
        }
        for (String actionNamePattern : actionNamePatterns) {
            if (!this.isMatched(actionName, actionNamePattern)) continue;
            return true;
        }
        return false;
    }

    boolean isMatched(String actionName, String actionNamePattern) {
        if (actionNamePattern == null) {
            return false;
        }
        Pattern pattern = this.patternMap_.get(actionNamePattern);
        if (pattern == null) {
            pattern = Pattern.compile(actionNamePattern);
            this.patternMap_.put(actionNamePattern, pattern);
        }
        return pattern.matcher(actionName).matches();
    }
}

