/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.extension.creator.ClassCreationHintBag;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassDescBag;
import org.seasar.ymir.extension.creator.ClassHint;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.PropertyTypeHint;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.Template;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.extension.creator.action.impl.AbstractAction;
import org.seasar.ymir.extension.creator.action.impl.ClassDescDto;
import org.seasar.ymir.extension.zpt.ParameterRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifyParametersAction
extends AbstractAction
implements UpdateAction {
    protected static final String PARAMPREFIX_PARAMETERROLE = "__ymir__parameterRole_";

    public ClassifyParametersAction(SourceCreator sourceCreator) {
        super(sourceCreator);
    }

    @Override
    public Response act(Request request, PathMetaData pathMetaData) {
        if (this.isSkipButtonPushed(request)) {
            return null;
        }
        String subTask = request.getParameter("__ymir__subTask");
        if ("classify".equals(subTask)) {
            return this.actClassify(request, pathMetaData);
        }
        return this.actDefault(request, pathMetaData);
    }

    boolean shouldUpdate(Request request, PathMetaData pathMetaData) {
        if (this.isTryingToUpdateClassesWhenTemplateModifiedAndModified(request, pathMetaData)) {
            return false;
        }
        return this.getUndecidedParameterNames(request, pathMetaData, null).length > 0;
    }

    boolean isTryingToUpdateClassesWhenTemplateModifiedAndModified(Request request, PathMetaData pathMetaData) {
        Template template = this.getSourceCreator().getTemplate(pathMetaData.getPath());
        if (!template.exists()) {
            return false;
        }
        if (this.getSourceCreatorSetting().isTryingToUpdateClassesWhenTemplateModified()) {
            return template.lastModified() > this.getSourceCreator().getCheckedTime(template);
        }
        return false;
    }

    protected String[] getUndecidedParameterNames(Request request, PathMetaData pathMetaData, ClassCreationHintBag hintBag) {
        String path = pathMetaData.getPath();
        HttpMethod method = request.getMethod();
        String className = pathMetaData.getClassName();
        ClassHint classHint = null;
        if (hintBag != null) {
            classHint = hintBag.getClassHint(className);
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator itr = request.getParameterNames();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            if (!"".equals(request.getParameter(name)) || this.getSourceCreator().inferParameterRole(path, method, className, name, classHint) != ParameterRole.UNDECIDED) continue;
            list.add(this.getSourceCreator().getActionKeyFromParameterName(path, method, name));
        }
        return list.toArray(new String[0]);
    }

    Response actDefault(Request request, PathMetaData pathMetaData) {
        if (!this.shouldUpdate(request, pathMetaData)) {
            return null;
        }
        if (request.getMethod() != HttpMethod.GET) {
            return null;
        }
        DescPool pool = this.newDescPool();
        pool.setBornOf("request:" + pathMetaData.getPath());
        ClassDesc classDesc = this.getSourceCreator().newClassDesc(pool, pathMetaData.getClassName(), null);
        classDesc.setAttribute("undecidedParameterNames", this.getUndecidedParameterNames(request, pathMetaData, null));
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("template", pathMetaData.getTemplate());
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("pathMetaData", pathMetaData);
        variableMap.put("classDesc", new ClassDescDto(classDesc, false));
        return this.getSourceCreator().getResponseCreator().createResponse("classifyParameters", variableMap);
    }

    Response actClassify(Request request, PathMetaData pathMetaData) {
        HttpMethod method = this.getHttpMethod(request);
        if (method == null) {
            return null;
        }
        this.updateMapping(pathMetaData);
        HashMap<String, ClassHint> classHintMap = new HashMap<String, ClassHint>();
        Iterator itr = request.getParameterNames();
        while (itr.hasNext()) {
            String classAndParameterName;
            int slash;
            String name = (String)itr.next();
            if (!name.startsWith(PARAMPREFIX_PARAMETERROLE) || (slash = (classAndParameterName = name.substring(PARAMPREFIX_PARAMETERROLE.length())).indexOf(47)) < 0) continue;
            String className = classAndParameterName.substring(0, slash);
            String parameterName = classAndParameterName.substring(slash + 1);
            ParameterRole role = ParameterRole.valueOf(request.getParameter(name));
            ClassHint classHint = (ClassHint)classHintMap.get(className);
            if (classHint == null) {
                classHint = new ClassHint(className);
                classHintMap.put(className, classHint);
            }
            classHint.setParameterRole(parameterName, role);
        }
        ClassCreationHintBag hintBag = new ClassCreationHintBag(new PropertyTypeHint[0], classHintMap.values().toArray(new ClassHint[0]));
        DescPool pool = this.newDescPool(hintBag);
        pool.setBornOf("request:" + pathMetaData.getPath());
        this.getSourceCreator().buildTransitionClassDesc(pool, pathMetaData.getPath(), method, this.filterSystemParamers(request.getParameterMap()));
        ClassDescBag classDescBag = this.getSourceCreator().gatherClassDescs(pool, null, false, pathMetaData);
        this.getSourceCreator().updateClasses(classDescBag);
        boolean successfullySynchronized = this.synchronizeResources(new String[]{this.getRootPackagePath()});
        this.pause(1000L);
        this.openJavaCodeInEclipseEditor(pathMetaData.getClassName());
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("pathMetaData", pathMetaData);
        variableMap.put("classDescBag", classDescBag);
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("classifyParameters_classify", variableMap);
    }

    private Map<String, String[]> filterSystemParamers(Map<String, String[]> parameterMap) {
        if (parameterMap == null) {
            return null;
        }
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("__ymir__")) continue;
            map.put(key, entry.getValue());
        }
        return map;
    }
}

