/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.io.File;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.Template;

public class PathMetaDataImpl
implements PathMetaData {
    private String path_;
    private HttpMethod method_;
    private boolean denied_;
    private String componentName_;
    private String className_;
    private String actionName_;
    private String defaultPath_;
    private File sourceFile_;
    private File baseSourceFile_;
    private Template template_;

    public PathMetaDataImpl(String path, HttpMethod method, boolean denied, String componentName, String className, String actionName, String defaultPath, File sourceFile, Template template) {
        this.path_ = path;
        this.method_ = method;
        this.denied_ = denied;
        this.componentName_ = componentName;
        this.className_ = className;
        this.actionName_ = actionName;
        this.defaultPath_ = defaultPath;
        this.sourceFile_ = sourceFile;
        this.baseSourceFile_ = this.toBaseSourceFile(sourceFile);
        this.template_ = template;
    }

    File toBaseSourceFile(File sourceFile) {
        if (sourceFile == null) {
            return null;
        }
        String name = sourceFile.getName();
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return new File(sourceFile.getParentFile(), name + "Base");
        }
        return new File(sourceFile.getParentFile(), name.substring(0, dot) + "Base" + name.substring(dot));
    }

    public HttpMethod getMethod() {
        return this.method_;
    }

    public String getPath() {
        return this.path_;
    }

    public boolean isDenied() {
        return this.denied_;
    }

    public String getComponentName() {
        return this.componentName_;
    }

    public String getClassName() {
        return this.className_;
    }

    public String getActionName() {
        return this.actionName_;
    }

    public String getDefaultPath() {
        return this.defaultPath_;
    }

    public File getSourceFile() {
        return this.sourceFile_;
    }

    public File getBaseSourceFile() {
        return this.baseSourceFile_;
    }

    public Template getTemplate() {
        return this.template_;
    }
}

