/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.servlet;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.seasar.ymir.FormFile;
import org.seasar.ymir.impl.FormFileImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartServletRequest
extends HttpServletRequestWrapper {
    public static final String ATTR_FORMFILEMAP = MultipartServletRequest.class.getName() + ".formFileMap";
    private HttpServletRequest request_;
    private Map<String, String[]> paramMap_;

    public MultipartServletRequest(HttpServletRequest request) {
        super(request);
        this.request_ = request;
        if (ServletFileUpload.isMultipartContent((RequestContext)new ServletRequestContext(request))) {
            String encoding = request.getCharacterEncoding();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setHeaderEncoding(encoding);
            try {
                this.paramMap_ = this.prepareParameters(upload.parseRequest(request), encoding);
            }
            catch (FileUploadException ex) {
                this.paramMap_ = request.getParameterMap();
            }
        } else {
            this.paramMap_ = request.getParameterMap();
        }
    }

    public String getParameter(String name) {
        String value = (String)this.getFirst(this.paramMap_.get(name));
        if (value == null) {
            value = super.getParameter(name);
        }
        return value;
    }

    public Map<String, String[]> getParameterMap() {
        return this.paramMap_;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.paramMap_.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.paramMap_.get(name);
    }

    private Map<String, String[]> prepareParameters(List<FileItem> fileItemList, String encoding) {
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>(this.request_.getParameterMap());
        HashMap<String, FormFile[]> fileMap = new HashMap<String, FormFile[]>();
        for (FileItem fileItem : fileItemList) {
            Object value;
            String fieldName = fileItem.getFieldName();
            if (fileItem.isFormField()) {
                try {
                    value = fileItem.getString(encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException("Can't happen!");
                }
                paramMap.put(fieldName, this.add((Object[])paramMap.get(fieldName), value, String.class));
                continue;
            }
            value = new FormFileImpl(fileItem);
            fileMap.put(fieldName, this.add((Object[])fileMap.get(fieldName), value, FormFile.class));
        }
        this.request_.setAttribute(ATTR_FORMFILEMAP, Collections.unmodifiableMap(fileMap));
        return Collections.unmodifiableMap(paramMap);
    }

    private <T> T[] add(T[] objs, T value, Class<T> clazz) {
        Object[] newObjs;
        if (objs == null) {
            newObjs = (Object[])Array.newInstance(clazz, 1);
            newObjs[0] = value;
        } else {
            newObjs = (Object[])Array.newInstance(objs.getClass().getComponentType(), objs.length + 1);
            System.arraycopy(objs, 0, newObjs, 0, objs.length);
            newObjs[objs.length] = value;
        }
        return newObjs;
    }

    private Object getFirst(Object obj) {
        Object[] objs = (Object[])obj;
        if (objs == null || objs.length == 0) {
            return null;
        }
        return objs[0];
    }
}

