/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.message.impl;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import org.seasar.ymir.message.Messages;
import org.seasar.ymir.message.Note;
import org.seasar.ymir.message.NoteRenderer;

public class NoteRendererImpl
implements NoteRenderer {
    private static final String PROPERTYPREFIX_NOTE_PARAMETER = "_.note.parameter.";
    private static final String PROPERTY_NOTE_PARAMETER_SEGMENT_DIRECTION = "_.note.parameter.segment.direction";
    private static final String PROPERTY_NOTE_PARAMETER_HEAD = "_.note.parameter.head";
    private static final String PROPERTY_NOTE_PARAMETER_DELIMITER = "_.note.parameter.delimiter";
    private static final String PROPERTY_NOTE_PARAMETER_TAIL = "_.note.parameter.tail";
    private static final String PROPERTY_NOTE_PARAMETER_SEGMENT_TEMPLATE = "_.note.parameter.segment.template";
    private static final String PROPERTYPREFIX_LABEL = "label.";
    private static final String DIRECTION_LEFT = "l";
    private static final String DELIMITER = ".";
    private static final String DIRECTION_DEFAULT = "r";
    private static final String PARAMETER_DELIMITER = "+";

    public String render(Note note, Messages messages) {
        return this.render(note.getValue(), note.getParameters(), messages);
    }

    public String render(String templateKey, Object[] parameters, Messages messages) {
        String v = null;
        if (parameters.length > 0 && parameters[0] != null) {
            v = messages.getMessage(templateKey + PARAMETER_DELIMITER + this.stripIndex(parameters[0].toString()));
        }
        if (v == null) {
            v = messages.getMessage(templateKey);
        }
        if (v == null) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof String)) continue;
            parameters[i] = this.localize((String)parameters[i], messages);
        }
        return MessageFormat.format(v, parameters);
    }

    protected String localize(String parameter, Messages messages) {
        String localized;
        int idx;
        String direction;
        String segmentTemplate = messages.getMessage(PROPERTY_NOTE_PARAMETER_SEGMENT_TEMPLATE);
        if (segmentTemplate == null) {
            String stripped = this.stripIndex(parameter);
            String message = messages.getMessage(PROPERTYPREFIX_LABEL + stripped);
            if (message == null) {
                message = messages.getMessage(PROPERTYPREFIX_LABEL + this.getLastSegment(stripped));
            }
            if (message == null) {
                message = parameter;
            }
            return message;
        }
        StringBuilder sb = new StringBuilder();
        String head = messages.getMessage(PROPERTY_NOTE_PARAMETER_HEAD);
        if (head != null) {
            sb.append(head);
        }
        if ((direction = messages.getMessage(PROPERTY_NOTE_PARAMETER_SEGMENT_DIRECTION)) == null) {
            direction = DIRECTION_DEFAULT;
        }
        boolean left = direction.toLowerCase().startsWith(DIRECTION_LEFT);
        String delimiter = messages.getMessage(PROPERTY_NOTE_PARAMETER_DELIMITER);
        if (delimiter == null) {
            delimiter = DELIMITER;
        }
        int pre = 0;
        LinkedList<String> localizedSegmentList = new LinkedList<String>();
        while ((idx = parameter.indexOf(DELIMITER, pre)) >= 0) {
            localized = this.localizeSegment(parameter.substring(pre, idx), messages, segmentTemplate);
            if (localized.length() > 0) {
                if (left) {
                    localizedSegmentList.addFirst(localized);
                } else {
                    localizedSegmentList.addLast(localized);
                }
            }
            pre = idx + 1;
        }
        localized = this.localizeSegment(parameter.substring(pre), messages, segmentTemplate);
        if (localized.length() > 0) {
            if (left) {
                localizedSegmentList.addFirst(localized);
            } else {
                localizedSegmentList.addLast(localized);
            }
        }
        String delim = "";
        Iterator itr = localizedSegmentList.iterator();
        while (itr.hasNext()) {
            sb.append(delim);
            delim = delimiter;
            sb.append((String)itr.next());
        }
        String tail = messages.getMessage(PROPERTY_NOTE_PARAMETER_TAIL);
        if (tail != null) {
            sb.append(tail);
        }
        return sb.toString();
    }

    String getLastSegment(String parameter) {
        if (parameter == null) {
            return null;
        }
        int delim = parameter.lastIndexOf(DELIMITER);
        if (delim < 0) {
            return parameter;
        }
        return parameter.substring(delim + 1);
    }

    String stripIndex(String parameter) {
        int idx;
        if (parameter == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int pre = 0;
        while ((idx = parameter.indexOf(91, pre)) >= 0) {
            sb.append(parameter.substring(pre, idx));
            int rparen = parameter.indexOf(93, idx + 1);
            if (rparen >= 0) {
                pre = rparen + 1;
                continue;
            }
            pre = parameter.length();
        }
        sb.append(parameter.substring(pre));
        return sb.toString();
    }

    String localizeSegment(String segment, Messages messages, String template) {
        int lparen;
        if (segment.endsWith("]") && (lparen = segment.indexOf(91)) >= 0) {
            String oneOriginIndex;
            String index = segment.substring(lparen + 1, segment.length() - 1);
            try {
                oneOriginIndex = String.valueOf(Integer.parseInt(index) + 1);
            }
            catch (NumberFormatException ex) {
                oneOriginIndex = index;
            }
            String localized = this.localizeSingle(segment.substring(0, lparen), messages);
            if (localized.length() > 0) {
                return MessageFormat.format(template, localized, index, oneOriginIndex);
            }
            return "";
        }
        return this.localizeSingle(segment, messages);
    }

    String localizeSingle(String single, Messages messages) {
        String message = messages.getMessage(PROPERTYPREFIX_LABEL + single);
        if (message != null) {
            return message;
        }
        return single;
    }
}

