/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.FollowingURLResolver;
import org.seasar.ymir.HttpServletResponseFilter;
import org.seasar.ymir.HttpServletResponseFilterFactory;
import org.seasar.ymir.PathResolver;
import org.seasar.ymir.RedirectionPathResolver;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.ResponseHeader;
import org.seasar.ymir.ResponseProcessor;
import org.seasar.ymir.Updater;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.impl.HttpServletResponseFilterFactoryImpl;
import org.seasar.ymir.impl.PathResolverImpl;
import org.seasar.ymir.impl.RedirectionPathResolverImpl;
import org.seasar.ymir.interceptor.YmirProcessInterceptor;
import org.seasar.ymir.util.ResponseUtils;
import org.seasar.ymir.util.ServletUtils;
import org.seasar.ymir.util.YmirUtils;

public class ResponseProcessorImpl
implements ResponseProcessor {
    private static final int BUF_SIZE = 4096;
    private Ymir ymir_;
    private Updater[] updaters_ = new Updater[0];
    private YmirProcessInterceptor[] ymirProcessInterceptors_ = new YmirProcessInterceptor[0];
    private PathResolver pathResolver_ = new PathResolverImpl();
    private RedirectionPathResolver redirectionPathResolver_ = new RedirectionPathResolverImpl();
    private FollowingURLResolver followingURLResolver_;
    private HttpServletResponseFilterFactory httpServletResponseFilterFactory_ = new HttpServletResponseFilterFactoryImpl();

    @Binding(bindingType=BindingType.MUST)
    public void setYmir(Ymir ymir) {
        this.ymir_ = ymir;
    }

    public void setUpdaters(Updater[] updaters) {
        this.updaters_ = updaters;
    }

    @Binding(value="@org.seasar.ymir.util.ContainerUtils@findAllComponents(container, @org.seasar.ymir.interceptor.YmirProcessInterceptor@class)", bindingType=BindingType.MUST)
    public void setYmirProcessInterceptors(YmirProcessInterceptor[] ymirProcessInterceptors) {
        this.ymirProcessInterceptors_ = ymirProcessInterceptors;
        YmirUtils.sortYmirProcessInterceptors(this.ymirProcessInterceptors_);
    }

    @Binding(bindingType=BindingType.MAY)
    public void setPathResolver(PathResolver pathResolver) {
        this.pathResolver_ = pathResolver;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setRedirectionPathResolver(RedirectionPathResolver redirectionPathResolver) {
        this.redirectionPathResolver_ = redirectionPathResolver;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setFollowingURLResolver(FollowingURLResolver followingURLResolver) {
        this.followingURLResolver_ = followingURLResolver;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setHttpServletResponseFilterFactory(HttpServletResponseFilterFactory httpServletResponseFilterFactory) {
        this.httpServletResponseFilterFactory_ = httpServletResponseFilterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpServletResponseFilter process(ServletContext context, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Request request, Response response) throws IOException, ServletException {
        this.adjustResponse(request, response);
        for (int i = 0; i < this.ymirProcessInterceptors_.length; ++i) {
            this.ymirProcessInterceptors_[i].responseProcessingStarted(context, httpRequest, httpResponse, request, response);
        }
        if (response.getStatus() != -1) {
            httpResponse.setStatus(response.getStatus());
        }
        if (response.getContentType() != null) {
            httpResponse.setContentType(response.getContentType());
        }
        switch (response.getType()) {
            case PASSTHROUGH: {
                this.populateHeaders(response, httpResponse);
                return this.constructResponseFilter(httpRequest, httpResponse, request);
            }
            case FORWARD: {
                String resolved;
                this.populateHeaders(response, httpResponse);
                if (response.isSubordinate()) {
                    resolved = response.getPath();
                } else {
                    resolved = this.resolveRedirectionPath(response.getPath(), httpRequest, httpResponse, request, response, true);
                    response.setPath(resolved);
                }
                context.getRequestDispatcher(resolved).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return null;
            }
            case REDIRECT: {
                this.populateHeaders(response, httpResponse);
                httpResponse.sendRedirect(this.resolveRedirectionPath(response.getPath(), httpRequest, httpResponse, request, response, false));
                return null;
            }
            case SELF_CONTAINED: {
                this.populateHeaders(response, httpResponse);
                InputStream is = null;
                ServletOutputStream os = null;
                try {
                    is = response.getInputStream();
                    if (is != null) {
                        int len;
                        os = httpResponse.getOutputStream();
                        BufferedInputStream bis = new BufferedInputStream(is);
                        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)os);
                        byte[] buf = new byte[4096];
                        while ((len = bis.read(buf)) >= 0) {
                            bos.write(buf, 0, len);
                        }
                        bos.flush();
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                return null;
            }
            case VOID: {
                return null;
            }
        }
        throw new RuntimeException("Unknown response type:" + (Object)((Object)response.getType()));
    }

    protected void adjustResponse(Request request, Response response) {
        if (ResponseUtils.isTransitionResponse(response)) {
            response.setPath(this.pathResolver_.resolve(response.getPath(), request));
        }
    }

    protected String resolveRedirectionPath(String path, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Request request, Response response, boolean proceed) {
        String resolved = proceed ? this.redirectionPathResolver_.resolveForProceed(path, httpRequest, httpResponse, request, response) : this.redirectionPathResolver_.resolve(path, httpRequest, httpResponse, request, response);
        if (resolved == null) {
            throw new NullPointerException("Redirection path is null: may logic is wrong");
        }
        if (!proceed) {
            if (this.shouldOmitSessionId()) {
                resolved = ServletUtils.omitSessionId(resolved);
            } else if (this.shouldAddSessionId(resolved) && !ServletUtils.isSessionIdEmbedded(resolved)) {
                resolved = httpResponse.encodeRedirectURL(resolved);
            }
            if (!this.followingURLResolver_.isResolved(resolved, httpRequest, httpResponse, request)) {
                resolved = this.followingURLResolver_.resolveURL(resolved, httpRequest, httpResponse, request);
            }
        }
        return resolved;
    }

    private boolean shouldOmitSessionId() {
        return PropertyUtils.valueOf((String)this.ymir_.getApplication().getProperty("core.session.omitSessionId"), (boolean)false);
    }

    protected boolean shouldAddSessionId(String url) {
        return url.indexOf(58) < 0;
    }

    protected void populateHeaders(Response response, HttpServletResponse httpResponse) {
        ResponseHeader[] headers = response.getResponseHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String name = headers[i].getName();
            Object value = headers[i].getValue();
            boolean add = headers[i].isAdd();
            if (value instanceof Integer) {
                if (add) {
                    httpResponse.addIntHeader(name, ((Integer)value).intValue());
                    continue;
                }
                httpResponse.setIntHeader(name, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                if (add) {
                    httpResponse.addDateHeader(name, ((Long)value).longValue());
                    continue;
                }
                httpResponse.setDateHeader(name, ((Long)value).longValue());
                continue;
            }
            if (add) {
                httpResponse.addHeader(name, String.valueOf(value));
                continue;
            }
            httpResponse.setHeader(name, String.valueOf(value));
        }
    }

    HttpServletResponseFilter constructResponseFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Request request) {
        if (!request.isIncluded() && this.ymir_.isUnderDevelopment() && YmirUtils.isUpdatable(request)) {
            return this.httpServletResponseFilterFactory_.newUpdaterResponseFilter(httpRequest, httpResponse, this.updaters_);
        }
        return this.httpServletResponseFilterFactory_.newAsIsResponseFilter(httpResponse);
    }
}

