/*
 * Copyright 2004-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.teeda.extension.mock;

import java.util.HashMap;
import java.util.Map;

import org.seasar.teeda.core.exception.UriNotFoundRuntimeException;
import org.seasar.teeda.extension.config.taglib.TaglibManager;
import org.seasar.teeda.extension.config.taglib.element.TaglibElement;

public class MockTaglibManager implements TaglibManager {

    private Map taglibElements = new HashMap();

    public TaglibElement getTaglibElement(String uri) {
        TaglibElement taglibElement = (TaglibElement) taglibElements.get(uri);
        if (taglibElement == null) {
            throw new UriNotFoundRuntimeException(uri);
        }
        return taglibElement;
    }

    public boolean hasTaglibElement(String uri) {
        return taglibElements.containsKey(uri);
    }

    public void addTaglibElement(TaglibElement taglibElement) {
        taglibElements.put(taglibElement.getUri(), taglibElement);
    }
}
