/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib;

import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.taglib.UIComponentTagPropertyUtil;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class UIComponentTagPropertyUtilTest
extends TeedaTestCase {
    public void testSetComponentProperty_beanProperty() throws Exception {
        MockHogeUIComponent component = new MockHogeUIComponent();
        UIComponentTagPropertyUtil.setComponentProperty((UIComponent)component, (String)"hoge", (String)"HOGE");
        UIComponentTagPropertyUtilTest.assertEquals((String)"HOGE", (String)component.getHoge());
        UIComponentTagPropertyUtil.setComponentProperty((UIComponent)component, (String)"foo", (String)"123");
        UIComponentTagPropertyUtilTest.assertTrue((boolean)(component.getFoo() instanceof Integer));
        UIComponentTagPropertyUtilTest.assertTrue((component.getFoo() == 123 ? 1 : 0) != 0);
        UIComponentTagPropertyUtil.setComponentProperty((UIComponent)component, (String)"bar", (String)"false");
        UIComponentTagPropertyUtilTest.assertFalse((boolean)component.isBar());
        UIComponentTagPropertyUtil.setComponentProperty((UIComponent)component, (String)"no_such_property", (String)"aaa");
        UIComponentTagPropertyUtilTest.assertEquals((Object)"aaa", component.getAttributes().get("no_such_property"));
    }

    public void testSetComponentProperty_ELProperty() throws Exception {
        MockHogeUIComponent component = new MockHogeUIComponent();
        UIComponentTagPropertyUtil.setComponentProperty((UIComponent)component, (String)"hoge", (String)"#{aaa.bbb}");
        ValueBinding vb = component.getValueBinding("hoge");
        UIComponentTagPropertyUtilTest.assertNotNull((Object)vb);
    }

    public static class MockHogeUIComponent
    extends MockUIComponent {
        private String hoge;
        private Integer foo;
        private boolean bar;

        public boolean isBar() {
            return this.bar;
        }

        public Integer getFoo() {
            return this.foo;
        }

        public String getHoge() {
            return this.hoge;
        }

        public void setBar(boolean bar) {
            this.bar = bar;
        }

        public void setFoo(Integer foo) {
            this.foo = foo;
        }

        public void setHoge(String hoge) {
            this.hoge = hoge;
        }
    }
}

