/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.ExpressionProcessor;
import org.seasar.teeda.core.el.impl.ValueBindingImpl;
import org.seasar.teeda.core.el.impl.commons.CommonsELParser;
import org.seasar.teeda.core.el.impl.commons.CommonsExpressionProcessorImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlDataTable;
import org.seasar.teeda.core.mock.MockHtmlOutputText;
import org.seasar.teeda.core.mock.MockHtmlPanelGroup;
import org.seasar.teeda.core.render.html.HtmlDataTableRenderer;
import org.seasar.teeda.core.render.html.HtmlOutputTextRenderer;
import org.seasar.teeda.core.render.html.HtmlPanelGroupRenderer;
import org.seasar.teeda.core.unit.TestUtil;

public class HtmlDataTableRendererTest
extends RendererTest {
    private HtmlDataTableRenderer renderer;
    private MockHtmlDataTable htmlDataTable;
    private HtmlOutputTextRenderer textRenderer;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlDataTableRenderer();
        this.textRenderer = new HtmlOutputTextRenderer();
        this.htmlDataTable = new MockHtmlDataTable();
        this.htmlDataTable.setRenderer((Renderer)this.renderer);
    }

    public void testEncodeBegin() throws Exception {
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlDataTable.setRendered(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableStyle() throws Exception {
        this.htmlDataTable.setStyle("s");
        this.htmlDataTable.setStyleClass("t");
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table class=\"t\" style=\"s\"", (String)this.getResponseText());
    }

    public void testEncodeBegin_Id() throws Exception {
        this.htmlDataTable.setId("aa");
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table id=\"aa\"", (String)this.getResponseText());
    }

    public void testEncodeBegin_WithUnknownAttribute() throws Exception {
        this.htmlDataTable.setId("aa");
        this.htmlDataTable.getAttributes().put("a", "b");
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table id=\"aa\" a=\"b\"", (String)this.getResponseText());
    }

    public void testEncode_NoValue() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><tbody></tbody></table>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableHeaderFacet() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        this.htmlDataTable.setHeader((UIComponent)facet);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><thead><tr><th scope=\"colgroup\">a</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableHeaderFacet2() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        MockHtmlOutputText c = new MockHtmlOutputText();
        c.setValue("a");
        c.setRenderer((Renderer)this.textRenderer);
        facet.getChildren().add(c);
        c = new MockHtmlOutputText();
        c.setValue("b");
        c.setRenderer((Renderer)this.textRenderer);
        facet.getChildren().add(c);
        this.htmlDataTable.setHeader((UIComponent)facet);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><thead><tr><th scope=\"colgroup\">ab</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableHeaderStyle() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        this.htmlDataTable.setHeader((UIComponent)facet);
        this.htmlDataTable.setHeaderClass("cc");
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><thead><tr><th scope=\"colgroup\" class=\"cc\">a</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableHeaderFacetRenderFalse() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        facet.setRendered(false);
        this.htmlDataTable.setHeader((UIComponent)facet);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table", (String)this.getResponseText());
    }

    public void testEncodeBegin_ColumnHeaderFacet() throws Exception {
        UIColumn col = new UIColumn();
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("c1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setHeader((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        colFacet = new MockHtmlOutputText();
        colFacet.setValue("c2");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setHeader((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><thead><tr><th colgroup=\"col\">c1</th><th colgroup=\"col\">c2</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_ColumnHeaderStyle() throws Exception {
        this.htmlDataTable.setHeaderClass("ccc");
        UIColumn col = new UIColumn();
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("c1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setHeader((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        colFacet = new MockHtmlOutputText();
        colFacet.setValue("c2");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setHeader((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><thead><tr><th colgroup=\"col\" class=\"ccc\">c1</th><th colgroup=\"col\" class=\"ccc\">c2</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_HeaderColumnRenderFalse() throws Exception {
        UIColumn col = new UIColumn();
        col.setRendered(false);
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("c1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setHeader((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        colFacet = new MockHtmlOutputText();
        colFacet.setValue("c2");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setHeader((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><thead><tr><th colgroup=\"col\">c2</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_ColumnHeaderFacetRenderFalse() throws Exception {
        UIColumn col = new UIColumn();
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("c1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        colFacet.setRendered(false);
        col.setHeader((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        colFacet = new MockHtmlOutputText();
        colFacet.setValue("c2");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setHeader((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><thead><tr><th colgroup=\"col\"></th><th colgroup=\"col\">c2</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_HeaderAndColumnsFacet() throws Exception {
        MockHtmlOutputText tableFacet = new MockHtmlOutputText();
        tableFacet.setRenderer((Renderer)this.textRenderer);
        tableFacet.setValue("a");
        this.htmlDataTable.setHeader((UIComponent)tableFacet);
        UIColumn col = new UIColumn();
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("c1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setHeader((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        MockHtmlOutputText colHeaderFacet = new MockHtmlOutputText();
        colHeaderFacet.setValue("c2");
        colHeaderFacet.setRenderer((Renderer)this.textRenderer);
        col.setHeader((UIComponent)colHeaderFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><thead><tr><th colspan=\"2\" scope=\"colgroup\">a</th></tr><tr><th colgroup=\"col\">c1</th><th colgroup=\"col\">c2</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_NotRenderHeaderColspanIfSingleColumn() throws Exception {
        MockHtmlOutputText tableHeaderFacet = new MockHtmlOutputText();
        tableHeaderFacet.setRenderer((Renderer)this.textRenderer);
        tableHeaderFacet.setValue("a");
        this.htmlDataTable.setHeader((UIComponent)tableHeaderFacet);
        UIColumn col = new UIColumn();
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("col1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setHeader((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><thead><tr><th scope=\"colgroup\">a</th></tr><tr><th colgroup=\"col\">col1</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableFooterFacet() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        this.htmlDataTable.setFooter((UIComponent)facet);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><tfoot><tr><td>a</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableFooterFacet2() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        MockHtmlOutputText c = new MockHtmlOutputText();
        c.setValue("a");
        c.setRenderer((Renderer)this.textRenderer);
        facet.getChildren().add(c);
        c = new MockHtmlOutputText();
        c.setValue("b");
        c.setRenderer((Renderer)this.textRenderer);
        facet.getChildren().add(c);
        this.htmlDataTable.setFooter((UIComponent)facet);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><tfoot><tr><td>ab</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableFooterStyle() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        this.htmlDataTable.setFooter((UIComponent)facet);
        this.htmlDataTable.setFooterClass("d");
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><tfoot><tr><td class=\"d\">a</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableFooterFacetRenderFalse() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        facet.setRendered(false);
        this.htmlDataTable.setFooter((UIComponent)facet);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table", (String)this.getResponseText());
    }

    public void testEncodeBegin_ColumnFooterFacet() throws Exception {
        UIColumn col = new UIColumn();
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("c1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        colFacet = new MockHtmlOutputText();
        colFacet.setValue("c2");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><tfoot><tr><td>c1</td><td>c2</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_ColumnFooterStyle() throws Exception {
        this.htmlDataTable.setFooterClass("ee");
        UIColumn col = new UIColumn();
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("c1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        colFacet = new MockHtmlOutputText();
        colFacet.setValue("c2");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><tfoot><tr><td class=\"ee\">c1</td><td class=\"ee\">c2</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_FooterColumnRenderFalse() throws Exception {
        UIColumn col = new UIColumn();
        col.setRendered(false);
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("c1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        colFacet = new MockHtmlOutputText();
        colFacet.setValue("c2");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><tfoot><tr><td>c2</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_ColumnFooterFacetRenderFalse() throws Exception {
        UIColumn col = new UIColumn();
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("c1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        colFacet.setRendered(false);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        colFacet = new MockHtmlOutputText();
        colFacet.setValue("c2");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><tfoot><tr><td></td><td>c2</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_FooterAndColumnsFacet() throws Exception {
        MockHtmlOutputText tableHeaderFacet = new MockHtmlOutputText();
        tableHeaderFacet.setRenderer((Renderer)this.textRenderer);
        tableHeaderFacet.setValue("a");
        this.htmlDataTable.setFooter((UIComponent)tableHeaderFacet);
        UIColumn col = new UIColumn();
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("col1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        colFacet = new MockHtmlOutputText();
        colFacet.setValue("col2");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><tfoot><tr><td colspan=\"2\">a</td></tr><tr><td>col1</td><td>col2</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_NotRenderFooterColspanIfSingleColumn() throws Exception {
        MockHtmlOutputText tableHeaderFacet = new MockHtmlOutputText();
        tableHeaderFacet.setRenderer((Renderer)this.textRenderer);
        tableHeaderFacet.setValue("a");
        this.htmlDataTable.setFooter((UIComponent)tableHeaderFacet);
        UIColumn col = new UIColumn();
        MockHtmlOutputText colFacet = new MockHtmlOutputText();
        colFacet.setValue("col1");
        colFacet.setRenderer((Renderer)this.textRenderer);
        col.setFooter((UIComponent)colFacet);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<table><tfoot><tr><td>a</td></tr><tr><td>col1</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeChildren1() throws Exception {
        this.htmlDataTable.setValue(new String[]{"a", "b", "c"});
        this.htmlDataTable.setVar("fooVar");
        UIColumn col = new UIColumn();
        MockHtmlOutputText htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        htmlOutputText.setValue("Z");
        col.getChildren().add(htmlOutputText);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(this.getFacesContext().getApplication(), "#{fooVar}", (ELParser)parser);
        htmlOutputText.setValueBinding("value", (ValueBinding)vb);
        col.getChildren().add(htmlOutputText);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeChildren((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<tbody><tr><td>Z</td><td>a</td></tr><tr><td>Z</td><td>b</td></tr><tr><td>Z</td><td>c</td></tr></tbody>", (String)this.getResponseText());
    }

    public void testEncodeChildren_WithNestedChildren() throws Exception {
        HtmlPanelGroupRenderer htmlPanelGroupRenderer = new HtmlPanelGroupRenderer();
        this.htmlDataTable.setValue(new String[]{"a", "b", "c"});
        this.htmlDataTable.setVar("fooVar");
        UIColumn col = new UIColumn();
        MockHtmlOutputText htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(this.getFacesContext().getApplication(), "#{fooVar}", (ELParser)parser);
        htmlOutputText.setValueBinding("value", (ValueBinding)vb);
        col.getChildren().add(htmlOutputText);
        MockHtmlPanelGroup group = new MockHtmlPanelGroup();
        group.setRenderer((Renderer)htmlPanelGroupRenderer);
        MockHtmlOutputText htmlOutputText2 = new MockHtmlOutputText();
        htmlOutputText2.setRenderer((Renderer)this.textRenderer);
        htmlOutputText2.setValue("y");
        group.getChildren().add(htmlOutputText2);
        htmlOutputText2 = new MockHtmlOutputText();
        htmlOutputText2.setRenderer((Renderer)this.textRenderer);
        htmlOutputText2.setValue("z");
        group.getChildren().add(htmlOutputText2);
        col.getChildren().add(group);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeChildren((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<tbody><tr><td>ayz</td></tr><tr><td>byz</td></tr><tr><td>cyz</td></tr></tbody>", (String)this.getResponseText());
    }

    public void testEncodeChildren_SetFirst() throws Exception {
        this.htmlDataTable.setValue(new String[]{"a", "b", "c"});
        this.htmlDataTable.setVar("fooVar");
        this.htmlDataTable.setFirst(1);
        UIColumn col = new UIColumn();
        col.setRendered(false);
        MockHtmlOutputText htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        htmlOutputText.setValue("Z");
        col.getChildren().add(htmlOutputText);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(this.getFacesContext().getApplication(), "#{fooVar}", (ELParser)parser);
        htmlOutputText.setValueBinding("value", (ValueBinding)vb);
        col.getChildren().add(htmlOutputText);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeChildren((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<tbody><tr><td>b</td></tr><tr><td>c</td></tr></tbody>", (String)this.getResponseText());
    }

    public void testEncodeChildren_SetRows() throws Exception {
        this.htmlDataTable.setValue(new String[]{"a", "b", "c", "d"});
        this.htmlDataTable.setVar("fooVar");
        this.htmlDataTable.setRows(2);
        UIColumn col = new UIColumn();
        col.setRendered(false);
        MockHtmlOutputText htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        htmlOutputText.setValue("Z");
        col.getChildren().add(htmlOutputText);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(this.getFacesContext().getApplication(), "#{fooVar}", (ELParser)parser);
        htmlOutputText.setValueBinding("value", (ValueBinding)vb);
        col.getChildren().add(htmlOutputText);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeChildren((FacesContext)context, (UIComponent)this.htmlDataTable);
        HtmlDataTableRendererTest.assertEquals((String)"<tbody><tr><td>a</td></tr><tr><td>b</td></tr></tbody>", (String)this.getResponseText());
    }

    public void testEncodeChildren_RowAndColumnStyle() throws Exception {
        this.htmlDataTable.setValue(new String[]{"a", "b", "c", "d", "e"});
        this.htmlDataTable.setVar("fooVar");
        this.htmlDataTable.setColumnClasses("c1, c2, c3");
        this.htmlDataTable.setRowClasses("r1, r2");
        UIColumn col = new UIColumn();
        MockHtmlOutputText htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        htmlOutputText.setValue("Z");
        col.getChildren().add(htmlOutputText);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        htmlOutputText.setValue("Y");
        col.getChildren().add(htmlOutputText);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        htmlOutputText.setValue("X");
        col.getChildren().add(htmlOutputText);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(this.getFacesContext().getApplication(), "#{fooVar}", (ELParser)parser);
        htmlOutputText.setValueBinding("value", (ValueBinding)vb);
        col.getChildren().add(htmlOutputText);
        this.htmlDataTable.getChildren().add(col);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeChildren((FacesContext)context, (UIComponent)this.htmlDataTable);
        String readText = TestUtil.readText(((Object)((Object)this)).getClass(), "testEncodeChildren_RowAndColumnStyle.html", "UTF-8");
        String expected = this.extract(readText);
        Diff diff = this.diff(expected, this.getResponseText());
        HtmlDataTableRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlDataTable.setBgcolor("gray");
        this.htmlDataTable.setBorder(3);
        this.htmlDataTable.setCellpadding("c");
        this.htmlDataTable.setCellspacing("d");
        this.htmlDataTable.setColumnClasses("e1, e2");
        this.htmlDataTable.setDir("f");
        this.htmlDataTable.setFooterClass("g");
        this.htmlDataTable.setFrame("h");
        this.htmlDataTable.setHeaderClass("i");
        this.htmlDataTable.setLang("j");
        this.htmlDataTable.setOnclick("k");
        this.htmlDataTable.setOndblclick("l");
        this.htmlDataTable.setOnkeydown("m");
        this.htmlDataTable.setOnkeypress("n");
        this.htmlDataTable.setOnkeyup("o");
        this.htmlDataTable.setOnmousedown("p");
        this.htmlDataTable.setOnmousemove("q");
        this.htmlDataTable.setOnmouseout("r");
        this.htmlDataTable.setOnmouseover("s");
        this.htmlDataTable.setOnmouseup("t");
        this.htmlDataTable.setRowClasses("u1, u2");
        this.htmlDataTable.setRules("v");
        this.htmlDataTable.setStyle("w");
        this.htmlDataTable.setStyleClass("x");
        this.htmlDataTable.setSummary("y");
        this.htmlDataTable.setTitle("z");
        this.htmlDataTable.setWidth("1");
        MockHtmlOutputText header = new MockHtmlOutputText();
        header.setRenderer((Renderer)this.textRenderer);
        header.setValue("tableHeader");
        this.htmlDataTable.setHeader((UIComponent)header);
        MockHtmlOutputText footer = new MockHtmlOutputText();
        footer.setRenderer((Renderer)this.textRenderer);
        footer.setValue("tableFooter");
        this.htmlDataTable.setFooter((UIComponent)footer);
        this.htmlDataTable.setFirst(4);
        this.htmlDataTable.setRows(3);
        this.htmlDataTable.setVar("barVar");
        this.htmlDataTable.setId("A");
        HashMap<String, String> m0 = new HashMap<String, String>();
        HashMap<String, String> m1 = new HashMap<String, String>();
        HashMap<String, String> m2 = new HashMap<String, String>();
        HashMap<String, String> m3 = new HashMap<String, String>();
        HashMap<String, String> m4 = new HashMap<String, String>();
        HashMap<String, String> m5 = new HashMap<String, String>();
        HashMap<String, String> m6 = new HashMap<String, String>();
        HashMap<String, String> m7 = new HashMap<String, String>();
        HashMap<String, String> m8 = new HashMap<String, String>();
        HashMap<String, String> m9 = new HashMap<String, String>();
        m0.put("k1", "a0");
        m1.put("k1", "a1");
        m2.put("k1", "a2");
        m3.put("k1", "a3");
        m4.put("k1", "a4");
        m5.put("k1", "a5");
        m6.put("k1", "a6");
        m7.put("k1", "a7");
        m8.put("k1", "a8");
        m9.put("k1", "a9");
        m0.put("k2", "b0");
        m1.put("k2", "b1");
        m2.put("k2", "b2");
        m3.put("k2", "b3");
        m4.put("k2", "b4");
        m5.put("k2", "b5");
        m6.put("k2", "b6");
        m7.put("k2", "b7");
        m8.put("k2", "b8");
        m9.put("k2", "b9");
        this.htmlDataTable.setValue(new Map[]{m0, m1, m2, m3, m4, m5, m6, m7, m8, m9});
        UIColumn col = new UIColumn();
        MockHtmlOutputText htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(this.getFacesContext().getApplication(), "#{barVar.k1}", (ELParser)parser);
        htmlOutputText.setValueBinding("value", (ValueBinding)vb);
        col.getChildren().add(htmlOutputText);
        MockHtmlOutputText header2 = new MockHtmlOutputText();
        header2.setRenderer((Renderer)this.textRenderer);
        header2.setValue("col1Header");
        col.setHeader((UIComponent)header2);
        MockHtmlOutputText footer2 = new MockHtmlOutputText();
        footer2.setRenderer((Renderer)this.textRenderer);
        footer2.setValue("col1Footer");
        col.setFooter((UIComponent)footer2);
        this.htmlDataTable.getChildren().add(col);
        col = new UIColumn();
        htmlOutputText = new MockHtmlOutputText();
        htmlOutputText.setRenderer((Renderer)this.textRenderer);
        parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        vb = new ValueBindingImpl(this.getFacesContext().getApplication(), "#{barVar.k2}", (ELParser)parser);
        htmlOutputText.setValueBinding("value", (ValueBinding)vb);
        col.getChildren().add(htmlOutputText);
        header2 = new MockHtmlOutputText();
        header2.setRenderer((Renderer)this.textRenderer);
        header2.setValue("col2Header");
        col.setHeader((UIComponent)header2);
        footer2 = new MockHtmlOutputText();
        footer2.setRenderer((Renderer)this.textRenderer);
        footer2.setValue("col2Footer");
        col.setFooter((UIComponent)footer2);
        this.htmlDataTable.getChildren().add(col);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlDataTable);
        String readText = TestUtil.readText(((Object)((Object)this)).getClass(), "testEncode_WithAllAttributes.html", "UTF-8");
        String expected = this.extract(readText);
        String responseText = this.getResponseText();
        System.out.println(responseText);
        Diff diff = this.diff(expected, responseText);
        HtmlDataTableRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlDataTableRendererTest.assertEquals((boolean)true, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlDataTableRenderer createHtmlDataTableRenderer() {
        return (HtmlDataTableRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlDataTableRenderer renderer = new HtmlDataTableRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

