/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.context.servlet;

import java.util.Iterator;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import junit.framework.TestCase;
import org.seasar.teeda.core.context.Releaseable;
import org.seasar.teeda.core.context.servlet.ServletFacesContextImpl;
import org.seasar.teeda.core.mock.MockApplicationFactory;
import org.seasar.teeda.core.mock.MockExternalContextImpl;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class ServletFacesContextImplTest
extends TestCase {
    private ServletFacesContextImpl context_;

    protected void setUp() throws Exception {
        super.setUp();
        FactoryFinder.setFactory((String)"javax.faces.application.ApplicationFactory", (String)MockApplicationFactory.class.getName());
        this.context_ = new ServletFacesContextImpl((ExternalContext)new MockExternalContextImpl());
    }

    protected void tearDown() throws Exception {
        this.context_.release();
        FactoryFinder.releaseFactories();
        super.tearDown();
    }

    public void testGetClientIdsWithMessages_NoMessage() throws Exception {
        Iterator it = this.context_.getClientIdsWithMessages();
        ServletFacesContextImplTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testGetClientIdsWithMessages_Released() throws Exception {
        this.context_.release();
        try {
            this.context_.getClientIdsWithMessages();
            ServletFacesContextImplTest.fail();
        }
        catch (IllegalStateException ise) {
            ExceptionAssert.assertMessageExist(ise);
        }
    }

    public void testGetClientIdsWithMessages_Messages() throws Exception {
        this.context_.addMessage(null, new FacesMessage());
        this.context_.addMessage("1", new FacesMessage());
        this.context_.addMessage("2", new FacesMessage());
        this.context_.addMessage("1", new FacesMessage());
        this.context_.addMessage(null, new FacesMessage());
        this.context_.addMessage(null, new FacesMessage());
        Iterator it = this.context_.getClientIdsWithMessages();
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals(null, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)"1", it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)"2", it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)"1", it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals(null, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals(null, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testGetMessages_NoMessage() throws Exception {
        Iterator it = this.context_.getMessages();
        ServletFacesContextImplTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testGetMessages_Released() throws Exception {
        this.context_.release();
        try {
            this.context_.getMessages();
            ServletFacesContextImplTest.fail();
        }
        catch (IllegalStateException ise) {
            ExceptionAssert.assertMessageExist(ise);
        }
    }

    public void testGetMessages_Messages() throws Exception {
        FacesMessage message1 = new FacesMessage();
        FacesMessage message2 = new FacesMessage();
        FacesMessage message3 = new FacesMessage();
        FacesMessage message4 = new FacesMessage();
        FacesMessage message5 = new FacesMessage();
        FacesMessage message6 = new FacesMessage();
        this.context_.addMessage(null, message1);
        this.context_.addMessage("1", message2);
        this.context_.addMessage("2", message3);
        this.context_.addMessage("1", message4);
        this.context_.addMessage(null, message5);
        this.context_.addMessage(null, message6);
        Iterator it = this.context_.getMessages();
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message1, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message2, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message3, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message4, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message5, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message6, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testGetMessagesByClientId_NoMessage() throws Exception {
        Iterator it = this.context_.getMessages("a");
        ServletFacesContextImplTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testGetMessagesByClientId_Released() throws Exception {
        this.context_.release();
        try {
            this.context_.getMessages("a");
            ServletFacesContextImplTest.fail();
        }
        catch (IllegalStateException ise) {
            ExceptionAssert.assertMessageExist(ise);
        }
    }

    public void testGetMessagesByClientId_Messages() throws Exception {
        FacesMessage message1 = new FacesMessage();
        FacesMessage message2 = new FacesMessage();
        FacesMessage message3 = new FacesMessage();
        FacesMessage message4 = new FacesMessage();
        FacesMessage message5 = new FacesMessage();
        FacesMessage message6 = new FacesMessage();
        this.context_.addMessage(null, message1);
        this.context_.addMessage("1", message2);
        this.context_.addMessage("2", message3);
        this.context_.addMessage("1", message4);
        this.context_.addMessage(null, message5);
        this.context_.addMessage(null, message6);
        Iterator it = this.context_.getMessages("a");
        ServletFacesContextImplTest.assertEquals((boolean)false, (boolean)it.hasNext());
        it = this.context_.getMessages("1");
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message2, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message4, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)false, (boolean)it.hasNext());
        it = this.context_.getMessages(null);
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message1, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message5, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message6, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)false, (boolean)it.hasNext());
        it = this.context_.getMessages("2");
        ServletFacesContextImplTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ServletFacesContextImplTest.assertEquals((Object)message3, it.next());
        ServletFacesContextImplTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testEnsureReleased() throws Exception {
        final boolean[] calls = new boolean[]{false};
        ServletFacesContextImpl context = new ServletFacesContextImpl((ExternalContext)new ReleaseableMockExternalContextImpl(){

            public void release() {
                calls[0] = true;
            }
        });
        context.release();
        ServletFacesContextImplTest.assertTrue((boolean)calls[0]);
    }

    public static class ReleaseableMockExternalContextImpl
    extends MockExternalContextImpl
    implements Releaseable {
        public void release() {
        }
    }
}

