/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.element.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.seasar.teeda.core.config.faces.element.RenderKitElement;
import org.seasar.teeda.core.config.faces.element.RendererElement;
import org.seasar.teeda.core.config.faces.element.impl.FacesConfigImpl;
import org.seasar.teeda.core.config.faces.element.impl.FacesConfigWrapperImpl;
import org.seasar.teeda.core.config.faces.element.impl.RenderKitElementImpl;
import org.seasar.teeda.core.config.faces.element.impl.RendererElementImpl;

public class FacesConfigWrapperImplTest
extends TestCase {
    public void testRenderKitElements1() throws Exception {
        RenderKitElementImpl renderKitElement = new RenderKitElementImpl();
        renderKitElement.setRenderKitId("renderKitId1");
        renderKitElement.setRenderKitClass("renderKitClass1");
        RendererElementImpl rendererElement = new RendererElementImpl();
        rendererElement.setComponentFamily("family1");
        rendererElement.setRendererType("type1");
        rendererElement.setRendererClass("class1");
        renderKitElement.addRendererElement((RendererElement)rendererElement);
        FacesConfigImpl facesConfig = new FacesConfigImpl();
        facesConfig.addRenderKitElement((RenderKitElement)renderKitElement);
        ArrayList<FacesConfigImpl> configs = new ArrayList<FacesConfigImpl>();
        configs.add(facesConfig);
        FacesConfigWrapperImpl configWrapper = new FacesConfigWrapperImpl(configs);
        Map renderKitElements = configWrapper.getRenderKitElements();
        RenderKitElement renderKit = (RenderKitElement)renderKitElements.get("renderKitId1");
        List rendererElements = renderKit.getRendererElements();
        FacesConfigWrapperImplTest.assertEquals((int)1, (int)rendererElements.size());
        RendererElement element = (RendererElement)rendererElements.get(0);
        FacesConfigWrapperImplTest.assertEquals((String)"family1", (String)element.getComponentFamily());
        FacesConfigWrapperImplTest.assertEquals((String)"type1", (String)element.getRendererType());
        FacesConfigWrapperImplTest.assertEquals((String)"class1", (String)element.getRendererClass());
    }

    public void testRenderKitElements_SameRenderKitId() throws Exception {
        ArrayList<FacesConfigImpl> configs = new ArrayList<FacesConfigImpl>();
        RenderKitElementImpl renderKitElement = new RenderKitElementImpl();
        renderKitElement.setRenderKitId("renderKitId1");
        renderKitElement.setRenderKitClass("renderKitClass1");
        RendererElementImpl rendererElement = new RendererElementImpl();
        rendererElement.setComponentFamily("family1");
        rendererElement.setRendererType("type1");
        rendererElement.setRendererClass("class1");
        renderKitElement.addRendererElement((RendererElement)rendererElement);
        FacesConfigImpl facesConfig = new FacesConfigImpl();
        facesConfig.addRenderKitElement((RenderKitElement)renderKitElement);
        configs.add(facesConfig);
        renderKitElement = new RenderKitElementImpl();
        renderKitElement.setRenderKitId("renderKitId1");
        renderKitElement.setRenderKitClass("renderKitClass1");
        rendererElement = new RendererElementImpl();
        rendererElement.setComponentFamily("family2");
        rendererElement.setRendererType("type2");
        rendererElement.setRendererClass("class2");
        renderKitElement.addRendererElement((RendererElement)rendererElement);
        facesConfig = new FacesConfigImpl();
        facesConfig.addRenderKitElement((RenderKitElement)renderKitElement);
        configs.add(facesConfig);
        FacesConfigWrapperImpl configWrapper = new FacesConfigWrapperImpl(configs);
        Map renderKitElements = configWrapper.getRenderKitElements();
        RenderKitElement renderKit = (RenderKitElement)renderKitElements.get("renderKitId1");
        List rendererElements = renderKit.getRendererElements();
        FacesConfigWrapperImplTest.assertEquals((int)2, (int)rendererElements.size());
        RendererElement element = (RendererElement)rendererElements.get(0);
        FacesConfigWrapperImplTest.assertEquals((String)"family1", (String)element.getComponentFamily());
        FacesConfigWrapperImplTest.assertEquals((String)"type1", (String)element.getRendererType());
        FacesConfigWrapperImplTest.assertEquals((String)"class1", (String)element.getRendererClass());
        element = (RendererElement)rendererElements.get(1);
        FacesConfigWrapperImplTest.assertEquals((String)"family2", (String)element.getComponentFamily());
        FacesConfigWrapperImplTest.assertEquals((String)"type2", (String)element.getRendererType());
        FacesConfigWrapperImplTest.assertEquals((String)"class2", (String)element.getRendererClass());
    }

    public void testRenderKitElements_NoSetRenderKitId_SameFacesConfig() throws Exception {
        ArrayList<FacesConfigImpl> configs = new ArrayList<FacesConfigImpl>();
        RenderKitElementImpl renderKitElement1 = new RenderKitElementImpl();
        RendererElementImpl rendererElement1 = new RendererElementImpl();
        String renderKitId = renderKitElement1.getRenderKitId();
        rendererElement1.setComponentFamily("family1");
        rendererElement1.setRendererType("type1");
        rendererElement1.setRendererClass("class1");
        renderKitElement1.addRendererElement((RendererElement)rendererElement1);
        RenderKitElementImpl renderKitElement2 = new RenderKitElementImpl();
        RendererElementImpl rendererElement2 = new RendererElementImpl();
        rendererElement2.setComponentFamily("family2");
        rendererElement2.setRendererType("type2");
        rendererElement2.setRendererClass("class2");
        renderKitElement2.addRendererElement((RendererElement)rendererElement2);
        FacesConfigImpl facesConfig = new FacesConfigImpl();
        facesConfig.addRenderKitElement((RenderKitElement)renderKitElement1);
        facesConfig.addRenderKitElement((RenderKitElement)renderKitElement2);
        configs.add(facesConfig);
        FacesConfigWrapperImpl configWrapper = new FacesConfigWrapperImpl(configs);
        Map renderKitElements = configWrapper.getRenderKitElements();
        RenderKitElement renderKit = (RenderKitElement)renderKitElements.get(renderKitId);
        List rendererElements = renderKit.getRendererElements();
        FacesConfigWrapperImplTest.assertEquals((int)2, (int)rendererElements.size());
        RendererElement element1 = (RendererElement)rendererElements.get(0);
        FacesConfigWrapperImplTest.assertEquals((String)"family1", (String)element1.getComponentFamily());
        FacesConfigWrapperImplTest.assertEquals((String)"type1", (String)element1.getRendererType());
        FacesConfigWrapperImplTest.assertEquals((String)"class1", (String)element1.getRendererClass());
        RendererElement element2 = (RendererElement)rendererElements.get(1);
        FacesConfigWrapperImplTest.assertEquals((String)"family2", (String)element2.getComponentFamily());
        FacesConfigWrapperImplTest.assertEquals((String)"type2", (String)element2.getRendererType());
        FacesConfigWrapperImplTest.assertEquals((String)"class2", (String)element2.getRendererClass());
    }
}

