/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.convert;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.seasar.teeda.core.convert.TimestampConverter;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.NullUIComponent;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class TimestampConverterTest
extends TeedaTestCase {
    public void testGetAsObject() throws Exception {
        TimestampConverter converter = (TimestampConverter)this.createConverter();
        MockFacesContext context = this.getFacesContext();
        converter.setLocale(Locale.getDefault());
        converter.setTimeZone(TimeZone.getDefault());
        String pattern = "yyyy/MM/dd";
        converter.setPattern("yyyy/MM/dd");
        String dateValue = "2006/06/06";
        Object o = converter.getAsObject((FacesContext)context, (UIComponent)new NullUIComponent(), dateValue);
        TimestampConverterTest.assertNotNull((Object)o);
        TimestampConverterTest.assertTrue((boolean)(o instanceof Timestamp));
    }

    public void testGetAsObject2() throws Exception {
        TimestampConverter converter = (TimestampConverter)this.createConverter();
        MockFacesContext context = this.getFacesContext();
        converter.setLocale(Locale.getDefault());
        converter.setTimeZone(TimeZone.getDefault());
        String pattern = "yyyy/MM/dd hh:mm:ss";
        converter.setPattern("yyyy/MM/dd hh:mm:ss");
        String dateValue = "2006/06/06 12:45:50";
        Timestamp timeStamp = (Timestamp)converter.getAsObject((FacesContext)context, (UIComponent)new NullUIComponent(), dateValue);
        Timestamp timestampTarget = this.createTimestampTarget("yyyy/MM/dd hh:mm:ss", Locale.getDefault(), dateValue);
        TimestampConverterTest.assertEquals((Object)timeStamp, (Object)timestampTarget);
    }

    public void testGetAsObject3() throws Exception {
        TimestampConverter converter = (TimestampConverter)this.createConverter();
        MockFacesContext context = this.getFacesContext();
        converter.setLocale(Locale.getDefault());
        converter.setTimeZone(TimeZone.getDefault());
        String pattern = "yyyy/MM/dd hh:mm:ss";
        converter.setPattern("yyyy/MM/dd hh:mm:ss");
        String dateValue = null;
        TimestampConverterTest.assertNull((Object)converter.getAsObject((FacesContext)context, (UIComponent)new NullUIComponent(), dateValue));
    }

    private Timestamp createTimestampTarget(String pattern, Locale locale, String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
        return new Timestamp(formatter.parse(date).getTime());
    }

    protected Converter createConverter() {
        return this.createTimestampConverter();
    }

    private TimestampConverter createTimestampConverter() {
        return new TimestampConverter();
    }
}

