/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.context.creator;

import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.PortletContext;
import org.seasar.framework.mock.portlet.MockPortletContextImpl;
import org.seasar.framework.mock.portlet.MockPortletRequestImpl;
import org.seasar.framework.mock.portlet.MockPortletResponseImpl;
import org.seasar.teeda.core.context.creator.DispatchableFacesContextCreator;
import org.seasar.teeda.core.context.creator.portlet.PortletFacesContextCreator;
import org.seasar.teeda.core.context.creator.servlet.ServletFacesContextCreator;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class DispatchableFacesContextCreatorTest
extends TeedaTestCase {
    public void testCreate_inCaseOfServletEnvironment() throws Exception {
        DispatchableFacesContextCreator creator = new DispatchableFacesContextCreator();
        creator.setServletFacesContextCreator(new ServletFacesContextCreator(){

            public FacesContext create(Object context, Object request, Object response, Lifecycle lifecycle) {
                return DispatchableFacesContextCreatorTest.this.getFacesContext();
            }
        });
        FacesContext context = creator.create((Object)this.getServletContext(), (Object)this.getRequest(), (Object)this.getResponse(), (Lifecycle)this.getLifecycle());
        DispatchableFacesContextCreatorTest.assertNotNull((Object)context);
        DispatchableFacesContextCreatorTest.assertTrue((boolean)(context instanceof MockFacesContext));
    }

    public void testCreate_inCaseOfPortletEnvironment() throws Exception {
        DispatchableFacesContextCreator creator = new DispatchableFacesContextCreator();
        creator.setPortletFacesContextCreator(new PortletFacesContextCreator(){

            public FacesContext create(Object context, Object request, Object response, Lifecycle lifecycle) {
                return DispatchableFacesContextCreatorTest.this.getFacesContext();
            }
        });
        MockPortletContextImpl portletContext = new MockPortletContextImpl("/hoge");
        FacesContext context = creator.create((Object)portletContext, (Object)new MockPortletRequestImpl((PortletContext)portletContext), (Object)new MockPortletResponseImpl(), (Lifecycle)this.getLifecycle());
        DispatchableFacesContextCreatorTest.assertNotNull((Object)context);
        DispatchableFacesContextCreatorTest.assertTrue((boolean)(context instanceof MockFacesContext));
    }

    public void testCreate_inCaseOfNoSuchEnvironment() throws Exception {
        DispatchableFacesContextCreatorTest.assertTrue((boolean)true);
    }
}

