/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import junit.framework.Assert;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.teeda.core.application.ViewHandlerImpl;
import org.seasar.teeda.core.config.webapp.element.ServletMappingElement;
import org.seasar.teeda.core.config.webapp.element.WebappConfig;
import org.seasar.teeda.core.config.webapp.element.impl.ServletMappingElementImpl;
import org.seasar.teeda.core.config.webapp.element.impl.WebappConfigImpl;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockExternalContext;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.mock.MockStateManager;
import org.seasar.teeda.core.mock.MockUIViewRoot;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ViewHandlerImplTest
extends TeedaTestCase {
    private MockApplication orgApp_;
    private MockHttpServletRequest orgReq_;

    protected void setUp() throws Exception {
        this.orgApp_ = this.getApplication();
        this.orgReq_ = this.getExternalContext().getMockHttpServletRequest();
    }

    protected void tearDown() throws Exception {
        this.setApplication(this.orgApp_);
        this.getExternalContext().setMockHttpServletRequest(this.orgReq_);
    }

    public void testCalculateLocale_facesContextIsNull() throws Exception {
        ViewHandlerImpl handler = new ViewHandlerImpl();
        try {
            handler.calculateLocale(null);
            ViewHandlerImplTest.fail();
        }
        catch (NullPointerException expected) {
            ViewHandlerImplTest.assertTrue((boolean)true);
        }
    }

    public void testGetLocaleFromSupportedLocales_isMatch() throws Exception {
        MockApplicationImpl mockApp = new MockApplicationImpl();
        mockApp.addSupportedLocale(Locale.ENGLISH);
        this.getFacesContext().setApplication((Application)mockApp);
        MockTeedaHttpServletRequestImpl req = new MockTeedaHttpServletRequestImpl((ServletContext)this.getServletContext());
        req.setLocale(Locale.ENGLISH);
        this.getExternalContext().setMockHttpServletRequest((MockHttpServletRequest)req);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        Locale l = handler.getLocaleFromSupportedLocales((FacesContext)this.getFacesContext());
        ViewHandlerImplTest.assertEquals((Object)Locale.ENGLISH, (Object)l);
    }

    public void testGetLocaleFromSupportedLocales_isNotMatch() throws Exception {
        MockApplicationImpl mockApp = new MockApplicationImpl();
        mockApp.addSupportedLocale(Locale.ENGLISH);
        this.getFacesContext().setApplication((Application)mockApp);
        MockTeedaHttpServletRequestImpl req = new MockTeedaHttpServletRequestImpl((ServletContext)this.getServletContext());
        req.setLocale(Locale.FRANCE);
        this.getExternalContext().setMockHttpServletRequest((MockHttpServletRequest)req);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        Locale l = handler.getLocaleFromSupportedLocales((FacesContext)this.getFacesContext());
        ViewHandlerImplTest.assertNull((Object)l);
    }

    public void testGetLocaleFromDefaultLocale_isMatch() throws Exception {
        MockApplicationImpl mockApp = new MockApplicationImpl();
        mockApp.setDefaultLocale(Locale.ENGLISH);
        this.getFacesContext().setApplication((Application)mockApp);
        MockTeedaHttpServletRequestImpl req = new MockTeedaHttpServletRequestImpl((ServletContext)this.getServletContext());
        req.setLocale(Locale.ENGLISH);
        this.getExternalContext().setMockHttpServletRequest((MockHttpServletRequest)req);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        Locale l = handler.getLocaleFromDefaultLocale((FacesContext)this.getFacesContext());
        ViewHandlerImplTest.assertEquals((Object)Locale.ENGLISH, (Object)l);
    }

    public void testGetLocaleFromDefaultLocale_isNotMatch() throws Exception {
        MockApplicationImpl mockApp = new MockApplicationImpl();
        mockApp.setDefaultLocale(Locale.JAPAN);
        this.getFacesContext().setApplication((Application)mockApp);
        MockTeedaHttpServletRequestImpl req = new MockTeedaHttpServletRequestImpl((ServletContext)this.getServletContext());
        req.setLocale(Locale.ENGLISH);
        this.getExternalContext().setMockHttpServletRequest((MockHttpServletRequest)req);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        Locale l = handler.getLocaleFromDefaultLocale((FacesContext)this.getFacesContext());
        ViewHandlerImplTest.assertNull((Object)l);
    }

    public void testIsMatchLocale_localeCompletelyMatch() throws Exception {
        ViewHandlerImpl handler = new ViewHandlerImpl();
        ViewHandlerImplTest.assertTrue((boolean)handler.isMatchLocale(Locale.FRANCE, Locale.FRANCE));
    }

    public void testIsMatchLocale_localeLanguageMatch() throws Exception {
        ViewHandlerImpl handler = new ViewHandlerImpl();
        ViewHandlerImplTest.assertTrue((boolean)handler.isMatchLocale(Locale.JAPAN, Locale.JAPANESE));
    }

    public void testIsMatchLocale_notMatchAtAll() throws Exception {
        ViewHandlerImpl handler = new ViewHandlerImpl();
        ViewHandlerImplTest.assertFalse((boolean)handler.isMatchLocale(Locale.ENGLISH, Locale.JAPAN));
    }

    public void testIsMatchLocale_null() throws Exception {
        ViewHandlerImpl handler = new ViewHandlerImpl();
        ViewHandlerImplTest.assertEquals((boolean)false, (boolean)handler.isMatchLocale(Locale.ENGLISH, null));
        ViewHandlerImplTest.assertEquals((boolean)true, (boolean)handler.isMatchLocale(null, null));
    }

    public void testCalculateRenderKitId_fromApplication() throws Exception {
        MockApplicationImpl app = new MockApplicationImpl();
        app.setDefaultRenderKitId("hoge");
        this.getFacesContext().setApplication((Application)app);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        String renderKitId = handler.calculateRenderKitId((FacesContext)this.getFacesContext());
        ViewHandlerImplTest.assertEquals((String)"hoge", (String)renderKitId);
    }

    public void testCalculateRenderKitId_fromRenderKitFactory() throws Exception {
        MockApplicationImpl app = new MockApplicationImpl();
        this.getFacesContext().setApplication((Application)app);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        String renderKitId = handler.calculateRenderKitId((FacesContext)this.getFacesContext());
        ViewHandlerImplTest.assertEquals((String)"HTML_BASIC", (String)renderKitId);
    }

    public void testCalculateRenderKitId_facesContextIsNull() throws Exception {
        ViewHandlerImpl handler = new ViewHandlerImpl();
        try {
            handler.calculateRenderKitId(null);
            ViewHandlerImplTest.fail();
        }
        catch (NullPointerException expected) {
            ViewHandlerImplTest.success();
        }
    }

    public void testGetUrlPattern_notMatchExtenstion() throws Exception {
        MockTeedaHttpServletRequestImpl req = new MockTeedaHttpServletRequestImpl((ServletContext)this.getServletContext(), "/teeda");
        req.setPathInfo(null);
        this.getExternalContext().setMockHttpServletRequest((MockHttpServletRequest)req);
        WebappConfigImpl webappConfig = new WebappConfigImpl();
        ServletMappingElementImpl servletMapping = new ServletMappingElementImpl();
        servletMapping.setServletName("hoge");
        servletMapping.setUrlPattern("/teeda");
        webappConfig.addServletMappingElement((ServletMappingElement)servletMapping);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        String url = handler.getUrlPattern((WebappConfig)webappConfig, (FacesContext)this.getFacesContext());
        ViewHandlerImplTest.assertNull((Object)url);
    }

    public void testGetUrlPattern_pathInfo() throws Exception {
        MockTeedaHttpServletRequestImpl req = new MockTeedaHttpServletRequestImpl((ServletContext)this.getServletContext(), "/teeda");
        req.setPathInfo("path");
        this.getExternalContext().setMockHttpServletRequest((MockHttpServletRequest)req);
        WebappConfigImpl webappConfig = new WebappConfigImpl();
        ServletMappingElementImpl servletMapping = new ServletMappingElementImpl();
        servletMapping.setServletName("hoge");
        servletMapping.setUrlPattern("/teeda.*");
        webappConfig.addServletMappingElement((ServletMappingElement)servletMapping);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        String url = handler.getUrlPattern((WebappConfig)webappConfig, (FacesContext)this.getFacesContext());
        ViewHandlerImplTest.assertEquals((String)"/teeda", (String)url);
    }

    public void testGetViewIdPath_getSimply() throws Exception {
        String servletPath = "/teeda";
        String pathInfo = "/test";
        String viewId = "/hoge.jsp";
        String urlPattern = "/teeda/*";
        String expected = "/teeda/hoge.jsp";
        this.settingUpExternalContextForViewHandler(servletPath, pathInfo, urlPattern);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        String url = handler.getViewIdPath((FacesContext)this.getFacesContext(), viewId);
        ViewHandlerImplTest.assertEquals((String)expected, (String)url);
    }

    public void testGetViewIdPath_getWithoutServletPath() throws Exception {
        String servletPath = "/";
        String pathInfo = "/test.jsf";
        String viewId = "/hoge.jsp";
        String urlPattern = "*.jsf";
        String expected = "/hoge.jsp";
        this.settingUpExternalContextForViewHandler(servletPath, pathInfo, urlPattern);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        String url = handler.getViewIdPath((FacesContext)this.getFacesContext(), viewId);
        ViewHandlerImplTest.assertEquals((String)expected, (String)url);
    }

    public void testGetViewIdPath_getWithJsfExtensionAndJsp() throws Exception {
        String servletPath = "/ext/a.jsf";
        String pathInfo = null;
        String viewId = "/teeda/hoge.jsp";
        String urlPattern = "*.jsf";
        String expected = "/teeda/hoge.jsf";
        this.settingUpExternalContextForViewHandler(servletPath, pathInfo, urlPattern);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        String url = handler.getViewIdPath((FacesContext)this.getFacesContext(), viewId);
        ViewHandlerImplTest.assertEquals((String)expected, (String)url);
    }

    public void testGetViewIdPath_getWithJsfExtension() throws Exception {
        String servletPath = "/ext/a.jsf";
        String pathInfo = null;
        String viewId = "/teeda/bbb";
        String urlPattern = "*.jsf";
        String expected = "/teeda/bbb.jsf";
        this.settingUpExternalContextForViewHandler(servletPath, pathInfo, urlPattern);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        String url = handler.getViewIdPath((FacesContext)this.getFacesContext(), viewId);
        ViewHandlerImplTest.assertEquals((String)expected, (String)url);
    }

    public void testGetActionUrl_succeed() throws Exception {
        String servletPath = "/teeda";
        String pathInfo = "/test";
        String viewId = "/hoge.jsp";
        String urlPattern = "/teeda/*";
        String expected = "/teeda/hoge.jsp";
        this.settingUpExternalContextForViewHandler(servletPath, pathInfo, urlPattern);
        MockServletContext orgServletContext = this.getServletContext();
        MockTeedaServletContextImpl mock = new MockTeedaServletContextImpl("");
        MockTeedaHttpServletRequestImpl req = new MockTeedaHttpServletRequestImpl((ServletContext)mock, servletPath);
        req.setPathInfo(pathInfo);
        this.getExternalContext().setMockHttpServletRequest((MockHttpServletRequest)req);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        String url = handler.getActionURL((FacesContext)this.getFacesContext(), viewId);
        ViewHandlerImplTest.assertEquals((String)expected, (String)url);
        this.setServletContext(orgServletContext);
    }

    public void testGetActionUrl_facesContextIsNull() throws Exception {
        try {
            new ViewHandlerImpl().getActionURL(null, "a");
            ViewHandlerImplTest.fail();
        }
        catch (NullPointerException expected) {
            ViewHandlerImplTest.success();
        }
    }

    public void testGetActionUrl_viewIdIsNull() throws Exception {
        try {
            new ViewHandlerImpl().getActionURL((FacesContext)this.getFacesContext(), null);
            ViewHandlerImplTest.fail();
        }
        catch (NullPointerException expected) {
            ViewHandlerImplTest.success();
        }
    }

    public void testGetResourceURL_facesContextIsNull() throws Exception {
        try {
            new ViewHandlerImpl().getResourceURL(null, "a");
            ViewHandlerImplTest.fail();
        }
        catch (NullPointerException expected) {
            ViewHandlerImplTest.success();
        }
    }

    public void testGetResourceURL_pathIsNull() throws Exception {
        try {
            new ViewHandlerImpl().getResourceURL((FacesContext)this.getFacesContext(), null);
            ViewHandlerImplTest.fail();
        }
        catch (NullPointerException expected) {
            ViewHandlerImplTest.success();
        }
    }

    public void testGetResourceURL_pathNotStartWithSlash() throws Exception {
        String resourceUrl = new ViewHandlerImpl().getResourceURL((FacesContext)this.getFacesContext(), "hoge");
        ViewHandlerImplTest.assertEquals((String)"hoge", (String)resourceUrl);
    }

    public void testGetResourceURL_pathStartWithSlash() throws Exception {
        MockServletContext orgServletContext = this.getServletContext();
        MockTeedaServletContextImpl mock = new MockTeedaServletContextImpl("/aaa");
        MockTeedaHttpServletRequestImpl req = new MockTeedaHttpServletRequestImpl((ServletContext)mock, "/");
        this.getExternalContext().setMockHttpServletRequest((MockHttpServletRequest)req);
        String resourceUrl = new ViewHandlerImpl().getResourceURL((FacesContext)this.getFacesContext(), "/hoge");
        ViewHandlerImplTest.assertEquals((String)"/aaa/hoge", (String)resourceUrl);
        this.setServletContext(orgServletContext);
    }

    public void testCreateView_viewRootAlreadyExist() throws Exception {
        this.getApplication().addComponent("javax.faces.ViewRoot", MockUIViewRoot.class.getName());
        this.getFacesContext().getViewRoot().setLocale(Locale.FRENCH);
        this.getFacesContext().getViewRoot().setRenderKitId("id");
        ViewHandlerImpl handler = new ViewHandlerImpl();
        UIViewRoot viewRoot = handler.createView((FacesContext)this.getFacesContext(), "viewId");
        ViewHandlerImplTest.assertNotNull((Object)viewRoot);
        ViewHandlerImplTest.assertTrue((boolean)(viewRoot instanceof MockUIViewRoot));
        ViewHandlerImplTest.assertEquals((Object)Locale.FRENCH, (Object)viewRoot.getLocale());
        ViewHandlerImplTest.assertEquals((String)"id", (String)viewRoot.getRenderKitId());
        ViewHandlerImplTest.assertEquals((String)"viewId", (String)viewRoot.getViewId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateView_viewRootCreate() throws Exception {
        MockFacesContext orgFacesContext = this.getFacesContext();
        try {
            MockFacesContextImpl context = new MockFacesContextImpl(){

                public UIViewRoot getViewRoot() {
                    return null;
                }
            };
            this.setFacesContext((MockFacesContext)context);
            MockApplicationImpl mockApp = new MockApplicationImpl();
            mockApp.setDefaultLocale(Locale.ENGLISH);
            mockApp.setDefaultRenderKitId("hoge");
            mockApp.addComponent("javax.faces.ViewRoot", MockUIViewRoot.class.getName());
            this.getFacesContext().setApplication((Application)mockApp);
            this.getFacesContext().setApplication((Application)mockApp);
            MockTeedaHttpServletRequestImpl req = new MockTeedaHttpServletRequestImpl((ServletContext)this.getServletContext());
            req.setLocale(Locale.ENGLISH);
            MockExternalContext extContext = this.getExternalContext();
            extContext.setMockHttpServletRequest((MockHttpServletRequest)req);
            context.setExternalContext((ExternalContext)extContext);
            ViewHandlerImpl handler = new ViewHandlerImpl();
            UIViewRoot viewRoot = handler.createView((FacesContext)this.getFacesContext(), "viewId");
            ViewHandlerImplTest.assertNotNull((Object)viewRoot);
            ViewHandlerImplTest.assertTrue((boolean)(viewRoot instanceof MockUIViewRoot));
            ViewHandlerImplTest.assertEquals((Object)Locale.ENGLISH, (Object)viewRoot.getLocale());
            ViewHandlerImplTest.assertEquals((String)"hoge", (String)viewRoot.getRenderKitId());
            ViewHandlerImplTest.assertEquals((String)"viewId", (String)viewRoot.getViewId());
        }
        finally {
            this.setFacesContext(orgFacesContext);
        }
        ViewHandlerImplTest.assertEquals((Object)orgFacesContext, (Object)this.getFacesContext());
    }

    public void testCreateView_facesContextIsNull() throws Exception {
        try {
            new ViewHandlerImpl().createView(null, "a");
            ViewHandlerImplTest.fail();
        }
        catch (NullPointerException expected) {
            ViewHandlerImplTest.success();
        }
    }

    public void testRestoreView_callStateManager() throws Exception {
        final boolean[] calls = new boolean[]{false};
        final MockFacesContext facesContext = this.getFacesContext();
        final UIViewRoot viewRoot = facesContext.getViewRoot();
        MockStateManager mockStateManager = new MockStateManager(){

            public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
                calls[0] = true;
                Assert.assertEquals((Object)facesContext, (Object)context);
                Assert.assertEquals((String)"fooViewId", (String)viewId);
                return viewRoot;
            }
        };
        this.getApplication().setStateManager((StateManager)mockStateManager);
        ViewHandlerImpl viewHandler = new ViewHandlerImpl();
        UIViewRoot restoredViewRoot = viewHandler.restoreView((FacesContext)facesContext, "fooViewId");
        ViewHandlerImplTest.assertEquals((boolean)true, (boolean)calls[0]);
        ViewHandlerImplTest.assertSame((Object)viewRoot, (Object)restoredViewRoot);
    }

    protected void settingUpExternalContextForViewHandler(String servletPath, String pathInfo, String urlPattern) {
        MockTeedaHttpServletRequestImpl req = new MockTeedaHttpServletRequestImpl((ServletContext)this.getServletContext(), servletPath);
        req.setPathInfo(pathInfo);
        this.getExternalContext().setMockHttpServletRequest((MockHttpServletRequest)req);
        WebappConfigImpl webappConfig = new WebappConfigImpl();
        ServletMappingElementImpl servletMapping = new ServletMappingElementImpl();
        servletMapping.setServletName("hoge");
        servletMapping.setUrlPattern(urlPattern);
        webappConfig.addServletMappingElement((ServletMappingElement)servletMapping);
        this.getExternalContext().getApplicationMap().put(WebappConfig.class.getName(), webappConfig);
    }

    private static class MockTeedaServletContextImpl
    implements MockServletContext {
        private String path_;

        public MockTeedaServletContextImpl(String path) {
            this.path_ = path;
        }

        public void addMimeType(String file, String type) {
        }

        public void setInitParameter(String name, String value) {
        }

        public ServletContext getContext(String arg0) {
            return null;
        }

        public int getMajorVersion() {
            return 0;
        }

        public int getMinorVersion() {
            return 0;
        }

        public String getMimeType(String arg0) {
            return null;
        }

        public Set getResourcePaths(String arg0) {
            return null;
        }

        public URL getResource(String arg0) throws MalformedURLException {
            return null;
        }

        public InputStream getResourceAsStream(String arg0) {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            return null;
        }

        public RequestDispatcher getNamedDispatcher(String arg0) {
            return null;
        }

        public Servlet getServlet(String arg0) throws ServletException {
            return null;
        }

        public Enumeration getServlets() {
            return null;
        }

        public Enumeration getServletNames() {
            return null;
        }

        public void log(String arg0) {
        }

        public void log(Exception arg0, String arg1) {
        }

        public void log(String arg0, Throwable arg1) {
        }

        public String getRealPath(String arg0) {
            return null;
        }

        public String getServerInfo() {
            return null;
        }

        public String getInitParameter(String arg0) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return null;
        }

        public Object getAttribute(String arg0) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public void setAttribute(String arg0, Object arg1) {
        }

        public void removeAttribute(String arg0) {
        }

        public String getServletContextName() {
            return this.path_;
        }

        public void setServletContextName(String servletContextName) {
        }

        public Map getInitParameterMap() {
            return null;
        }

        public MockHttpServletRequest createRequest(String path) {
            return null;
        }
    }

    private static class MockTeedaHttpServletRequestImpl
    extends MockHttpServletRequestImpl {
        private Vector locales = new Vector();

        public MockTeedaHttpServletRequestImpl(ServletContext context, String servletPath) {
            super(context, servletPath);
        }

        public MockTeedaHttpServletRequestImpl(ServletContext context) {
            super(context, "/hello.html");
        }

        public void setLocale(Locale locale) {
            super.setLocale(locale);
            this.locales.add(locale);
        }

        public Enumeration getLocales() {
            return this.locales.elements();
        }
    }
}

