/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el.impl;

import java.util.Map;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.VariableResolver;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.ExpressionProcessor;
import org.seasar.teeda.core.el.ValueBindingBase;
import org.seasar.teeda.core.managedbean.ManagedBeanFactory;
import org.seasar.teeda.core.managedbean.ManagedBeanScopeSaver;
import org.seasar.teeda.core.scope.Scope;
import org.seasar.teeda.core.util.PropertyResolverUtil;
import org.seasar.teeda.core.util.VariableResolverUtil;

public class ValueBindingImpl
extends ValueBindingBase {
    private Application application;
    private String expressionString;
    private ELParser parser;
    private Object expression;
    private boolean transientValue = false;

    public ValueBindingImpl() {
    }

    public ValueBindingImpl(Application application, String expressionStr, ELParser p) {
        this.application = application;
        this.expressionString = expressionStr;
        this.parser = p;
        this.expression = p.parse(this.expressionString);
    }

    public Object getValue(FacesContext context) throws EvaluationException, PropertyNotFoundException {
        try {
            return this.parser.getExpressionProcessor().evaluate(context, this.expression);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyNotFoundException(e);
        }
        catch (EvaluationException e) {
            throw e;
        }
    }

    public void setValue(FacesContext context, Object newValue) throws EvaluationException, PropertyNotFoundException {
        AssertionUtil.assertNotNull((String)"context is null.", (Object)context);
        try {
            ExpressionProcessor processor = this.parser.getExpressionProcessor();
            Object obj = processor.resolveBase(context, this.expression);
            if (obj == null) {
                throw new EvaluationException();
            }
            if (obj instanceof String) {
                String name = (String)obj;
                if (ValueBindingImpl.isImplicitObject(name)) {
                    throw new ReferenceSyntaxException("Prohibited to set to implicit object.");
                }
                this.setValueInScope(context, name, newValue);
            } else {
                Object[] bases = (Object[])obj;
                Object base = bases[0];
                Object property = bases[1];
                Integer index = this.parser.getExpressionProcessor().toIndex(base, property);
                PropertyResolver resolver = this.application.getPropertyResolver();
                if (index == null) {
                    resolver.setValue(base, property, newValue);
                } else {
                    resolver.setValue(base, index, newValue);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyNotFoundException(e);
        }
    }

    protected void setValueInScope(FacesContext context, String name, Object newValue) {
        Object previous;
        VariableResolver resolver = this.application.getVariableResolver();
        ExpressionProcessor processor = this.parser.getExpressionProcessor();
        Map scopeMap = VariableResolverUtil.getDefaultScopeMap(context, resolver, name);
        if (scopeMap != null && (previous = scopeMap.get(name)) != null) {
            scopeMap.put(name, processor.getCoercedObject(newValue, previous.getClass()));
            return;
        }
        ManagedBeanFactory managedBeanFactory = this.getManagedBeanFactory();
        Scope scope = managedBeanFactory.getManagedBeanScope(name);
        ManagedBeanScopeSaver saver = managedBeanFactory.getManagedBeanScopeSaver();
        if (scope != null) {
            saver.saveToScope(context, scope, name, newValue);
            return;
        }
        saver.saveToScope(context, Scope.REQUEST, name, newValue);
    }

    public boolean isReadOnly(FacesContext context) throws EvaluationException, PropertyNotFoundException {
        Object obj = this.parser.getExpressionProcessor().resolveBase(context, this.expression);
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return ValueBindingImpl.isImplicitObject((String)obj);
        }
        Object[] bases = (Object[])obj;
        Object base = bases[0];
        Object property = bases[1];
        Integer index = this.parser.getExpressionProcessor().toIndex(base, property);
        return PropertyResolverUtil.isReadOnly(this.application, base, property, index);
    }

    public Class getType(FacesContext context) throws EvaluationException, PropertyNotFoundException {
        Object obj = this.parser.getExpressionProcessor().resolveBase(context, this.expression);
        if (obj == null) {
            return this.getValue(context).getClass();
        }
        if (obj instanceof String) {
            String name = (String)obj;
            ManagedBeanFactory managedBeanFactory = this.getManagedBeanFactory();
            Object managedBean = managedBeanFactory.getManagedBean(name);
            if (managedBean != null) {
                return managedBean.getClass();
            }
            Object value = this.application.getVariableResolver().resolveVariable(context, name);
            return value != null ? value.getClass() : Object.class;
        }
        Object[] bases = (Object[])obj;
        Object base = bases[0];
        Object property = bases[1];
        Integer index = this.parser.getExpressionProcessor().toIndex(base, property);
        return PropertyResolverUtil.getType(this.application, base, property, index);
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    public Object getExpression() {
        return this.expression;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.expressionString, this.parser};
        return state;
    }

    public void restoreState(FacesContext context, Object obj) {
        Object[] state = (Object[])obj;
        this.application = context.getApplication();
        this.expressionString = (String)state[0];
        this.parser = (ELParser)state[1];
        this.expression = this.parser.parse(this.expressionString);
    }
}

