/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import java.util.Iterator;
import java.util.List;
import org.seasar.teeda.core.config.faces.assembler.FactoryAssembler;
import org.seasar.teeda.core.config.faces.assembler.FactoryChildAssembler;
import org.seasar.teeda.core.config.faces.element.FactoryElement;
import org.seasar.teeda.core.util.IteratorUtil;

public class DefaultFactoryAssembler
extends FactoryAssembler {
    private FactoryChildAssembler applicationFactory_;
    private FactoryChildAssembler facesContextFactory_;
    private FactoryChildAssembler lifecycleFactory_;
    private FactoryChildAssembler renderKitFactory_;

    public DefaultFactoryAssembler(List factories) {
        super(factories);
    }

    protected void setupBeforeAssemble() {
        this.applicationFactory_ = new FactoryChildAssembler(){

            protected String getFactoryClassName() {
                return "javax.faces.application.ApplicationFactory";
            }
        };
        this.facesContextFactory_ = new FactoryChildAssembler(){

            protected String getFactoryClassName() {
                return "javax.faces.context.FacesContextFactory";
            }
        };
        this.lifecycleFactory_ = new FactoryChildAssembler(){

            protected String getFactoryClassName() {
                return "javax.faces.lifecycle.LifecycleFactory";
            }
        };
        this.renderKitFactory_ = new FactoryChildAssembler(){

            protected String getFactoryClassName() {
                return "javax.faces.render.RenderKitFactory";
            }
        };
        Iterator itr = IteratorUtil.getIterator(this.getFactories());
        while (itr.hasNext()) {
            FactoryElement factory = (FactoryElement)itr.next();
            this.applicationFactory_.setTargetFactories(factory.getApplicationFactories());
            this.facesContextFactory_.setTargetFactories(factory.getFacesContextFactories());
            this.lifecycleFactory_.setTargetFactories(factory.getLifecycleFactories());
            this.renderKitFactory_.setTargetFactories(factory.getRenderKitFactories());
        }
    }

    protected void assembleApplicationFactory() {
        this.applicationFactory_.assemble();
    }

    protected void assembleFacesContextFactory() {
        this.facesContextFactory_.assemble();
    }

    protected void assembleLifecycleFactory() {
        this.lifecycleFactory_.assemble();
    }

    protected void assembleRenderKitFactory() {
        this.renderKitFactory_.assemble();
    }
}

